"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SoundSwitchCC_exports = {};
__export(SoundSwitchCC_exports, {
  SoundSwitchCC: () => SoundSwitchCC,
  SoundSwitchCCAPI: () => SoundSwitchCCAPI,
  SoundSwitchCCConfigurationGet: () => SoundSwitchCCConfigurationGet,
  SoundSwitchCCConfigurationReport: () => SoundSwitchCCConfigurationReport,
  SoundSwitchCCConfigurationSet: () => SoundSwitchCCConfigurationSet,
  SoundSwitchCCToneInfoGet: () => SoundSwitchCCToneInfoGet,
  SoundSwitchCCToneInfoReport: () => SoundSwitchCCToneInfoReport,
  SoundSwitchCCTonePlayGet: () => SoundSwitchCCTonePlayGet,
  SoundSwitchCCTonePlayReport: () => SoundSwitchCCTonePlayReport,
  SoundSwitchCCTonePlaySet: () => SoundSwitchCCTonePlaySet,
  SoundSwitchCCTonesNumberGet: () => SoundSwitchCCTonesNumberGet,
  SoundSwitchCCTonesNumberReport: () => SoundSwitchCCTonesNumberReport,
  SoundSwitchCCValues: () => import_CCValues_generated.SoundSwitchCCValues
});
module.exports = __toCommonJS(SoundSwitchCC_exports);
var __validateArgs = __toESM(require("./SoundSwitchCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_math = require("alcalzone-shared/math");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_SoundSwitchCCAPI_getToneInfo, validateArgs_SoundSwitchCCAPI_setConfiguration, validateArgs_SoundSwitchCCAPI_play } = __validateArgs;
let SoundSwitchCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Sound Switch"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _getToneInfo_decorators;
  let _setConfiguration_decorators;
  let _play_decorators;
  var SoundSwitchCCAPI2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(this, null, _getToneInfo_decorators, { kind: "method", name: "getToneInfo", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getToneInfo" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getToneInfo, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setConfiguration_decorators, { kind: "method", name: "setConfiguration", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setConfiguration" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setConfiguration, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _play_decorators, { kind: "method", name: "play", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "play" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.play, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.SoundSwitchCommand.TonesNumberGet:
        case import_Types.SoundSwitchCommand.ToneInfoGet:
        case import_Types.SoundSwitchCommand.ConfigurationGet:
        case import_Types.SoundSwitchCommand.TonePlayGet:
          return this.isSinglecast();
        case import_Types.SoundSwitchCommand.ConfigurationSet:
        case import_Types.SoundSwitchCommand.TonePlaySet:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    async getToneCount() {
      this.assertSupportsCommand(import_Types.SoundSwitchCommand, import_Types.SoundSwitchCommand.TonesNumberGet);
      const cc = new SoundSwitchCCTonesNumberGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.toneCount;
    }
    async getToneInfo(toneId) {
      this.assertSupportsCommand(import_Types.SoundSwitchCommand, import_Types.SoundSwitchCommand.ToneInfoGet);
      const cc = new SoundSwitchCCToneInfoGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        toneId
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response)
        return (0, import_shared.pick)(response, ["duration", "name"]);
    }
    async setConfiguration(defaultToneId, defaultVolume) {
      this.assertSupportsCommand(import_Types.SoundSwitchCommand, import_Types.SoundSwitchCommand.ConfigurationSet);
      const cc = new SoundSwitchCCConfigurationSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        defaultToneId,
        defaultVolume
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getConfiguration() {
      this.assertSupportsCommand(import_Types.SoundSwitchCommand, import_Types.SoundSwitchCommand.ConfigurationGet);
      const cc = new SoundSwitchCCConfigurationGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["defaultToneId", "defaultVolume"]);
      }
    }
    async play(toneId, volume) {
      this.assertSupportsCommand(import_Types.SoundSwitchCommand, import_Types.SoundSwitchCommand.TonePlaySet);
      if (toneId === 0) {
        throw new import_core.ZWaveError(`Tone ID must be > 0. Use stopPlaying to stop the tone.`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const cc = new SoundSwitchCCTonePlaySet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        toneId,
        volume
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async stopPlaying() {
      this.assertSupportsCommand(import_Types.SoundSwitchCommand, import_Types.SoundSwitchCommand.TonePlaySet);
      const cc = new SoundSwitchCCTonePlaySet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        toneId: 0,
        volume: 0
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async getPlaying() {
      this.assertSupportsCommand(import_Types.SoundSwitchCommand, import_Types.SoundSwitchCommand.TonePlayGet);
      const cc = new SoundSwitchCCTonePlayGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["toneId", "volume"]);
      }
    }
    get [(_getToneInfo_decorators = [validateArgs_SoundSwitchCCAPI_getToneInfo()], _setConfiguration_decorators = [validateArgs_SoundSwitchCCAPI_setConfiguration()], _play_decorators = [validateArgs_SoundSwitchCCAPI_play()], import_API.SET_VALUE)]() {
      return async function({ property }, value, options) {
        if (property === "defaultToneId") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          return this.setConfiguration(value, 255);
        } else if (property === "defaultVolume") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          return this.setConfiguration(
            0,
            /* keep current tone */
            value
          );
        } else if (property === "volume") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          this.tryGetValueDB()?.setValue(import_CCValues_generated.SoundSwitchCCValues.volume.endpoint(this.endpoint.index), value, { source: "driver", updateTimestamp: false });
        } else if (property === "toneId") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          let result;
          if (value > 0) {
            const volume = options?.volume !== void 0 ? options.volume : this.tryGetValueDB()?.getValue(import_CCValues_generated.SoundSwitchCCValues.volume.endpoint(this.endpoint.index));
            result = await this.play(value, volume);
          } else {
            result = await this.stopPlaying();
          }
          if (this.isSinglecast() && !(0, import_core.supervisedCommandSucceeded)(result)) {
            this.schedulePoll({ property }, value, {
              transition: "fast"
            });
          }
          return result;
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "defaultToneId":
          case "defaultVolume":
            return (await this.getConfiguration())?.[property];
          case "toneId":
          case "volume":
            return (await this.getPlaying())?.[property];
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return SoundSwitchCCAPI2 = _classThis;
})();
let SoundSwitchCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Sound Switch"]), (0, import_CommandClassDecorators.implementedVersion)(2), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.SoundSwitchCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var SoundSwitchCC2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Sound Switch"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        message: "requesting tone count...",
        direction: "outbound"
      });
      const toneCount = await api.getToneCount();
      if (toneCount != void 0) {
        const logMessage = `supports ${toneCount} tones`;
        ctx.logNode(node.id, {
          message: logMessage,
          direction: "inbound"
        });
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying tone count timed out, skipping interview...",
          level: "warn"
        });
        return;
      }
      ctx.logNode(node.id, {
        message: "requesting current sound configuration...",
        direction: "outbound"
      });
      const config = await api.getConfiguration();
      if (config) {
        const logMessage = `received current sound configuration:
default tone ID: ${config.defaultToneId}
default volume: ${config.defaultVolume}`;
        ctx.logNode(node.id, {
          message: logMessage,
          direction: "inbound"
        });
      }
      const metadataStates = {};
      for (let toneId = 1; toneId <= toneCount; toneId++) {
        ctx.logNode(node.id, {
          message: `requesting info for tone #${toneId}`,
          direction: "outbound"
        });
        const info = await api.getToneInfo(toneId);
        if (!info)
          continue;
        const logMessage = `received info for tone #${toneId}:
name:     ${info.name}
duration: ${info.duration} seconds`;
        ctx.logNode(node.id, {
          message: logMessage,
          direction: "inbound"
        });
        metadataStates[toneId] = `${info.name} (${info.duration} sec)`;
      }
      this.setMetadata(ctx, import_CCValues_generated.SoundSwitchCCValues.defaultToneId, {
        ...import_CCValues_generated.SoundSwitchCCValues.defaultToneId.meta,
        min: 1,
        max: toneCount,
        states: metadataStates
      });
      this.setMetadata(ctx, import_CCValues_generated.SoundSwitchCCValues.toneId, {
        ...import_CCValues_generated.SoundSwitchCCValues.toneId.meta,
        min: 0,
        max: toneCount,
        states: {
          0: "off",
          ...metadataStates,
          [255]: "default"
        }
      });
      this.setInterviewComplete(ctx, true);
    }
  };
  return SoundSwitchCC2 = _classThis;
})();
let SoundSwitchCCTonesNumberReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SoundSwitchCommand.TonesNumberReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SoundSwitchCC;
  var SoundSwitchCCTonesNumberReport2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCTonesNumberReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCTonesNumberReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.toneCount = options.toneCount;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const toneCount = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        toneCount
      });
    }
    toneCount;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.toneCount]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "# of tones": this.toneCount }
      };
    }
  };
  return SoundSwitchCCTonesNumberReport2 = _classThis;
})();
let SoundSwitchCCTonesNumberGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SoundSwitchCommand.TonesNumberGet), (0, import_CommandClassDecorators.expectedCCResponse)(SoundSwitchCCTonesNumberReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SoundSwitchCC;
  var SoundSwitchCCTonesNumberGet2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCTonesNumberGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCTonesNumberGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SoundSwitchCCTonesNumberGet2 = _classThis;
})();
let SoundSwitchCCToneInfoReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SoundSwitchCommand.ToneInfoReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SoundSwitchCC;
  var SoundSwitchCCToneInfoReport2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCToneInfoReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCToneInfoReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.toneId = options.toneId;
      this.duration = options.duration;
      this.name = options.name;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const toneId = raw.payload[0];
      const duration = raw.payload.readUInt16BE(1);
      const nameLength = raw.payload[3];
      (0, import_core.validatePayload)(raw.payload.length >= 4 + nameLength);
      const name = raw.payload.subarray(4, 4 + nameLength).toString("utf8");
      return new this({
        nodeId: ctx.sourceNodeId,
        toneId,
        duration,
        name
      });
    }
    toneId;
    duration;
    name;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.toneId, 0, 0, this.name.length]),
        import_shared.Bytes.from(this.name, "utf8")
      ]);
      this.payload.writeUInt16BE(this.duration, 1);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "tone id": this.toneId,
          duration: `${this.duration} seconds`,
          name: this.name
        }
      };
    }
  };
  return SoundSwitchCCToneInfoReport2 = _classThis;
})();
const testResponseForSoundSwitchToneInfoGet = /* @__PURE__ */ __name((sent, received) => {
  return received.toneId === sent.toneId;
}, "testResponseForSoundSwitchToneInfoGet");
let SoundSwitchCCToneInfoGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SoundSwitchCommand.ToneInfoGet), (0, import_CommandClassDecorators.expectedCCResponse)(SoundSwitchCCToneInfoReport, testResponseForSoundSwitchToneInfoGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SoundSwitchCC;
  var SoundSwitchCCToneInfoGet2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCToneInfoGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCToneInfoGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.toneId = options.toneId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const toneId = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        toneId
      });
    }
    toneId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.toneId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "tone id": this.toneId }
      };
    }
  };
  return SoundSwitchCCToneInfoGet2 = _classThis;
})();
let SoundSwitchCCConfigurationSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SoundSwitchCommand.ConfigurationSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SoundSwitchCC;
  var SoundSwitchCCConfigurationSet2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCConfigurationSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCConfigurationSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.defaultVolume = options.defaultVolume;
      this.defaultToneId = options.defaultToneId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const defaultVolume = raw.payload[0];
      const defaultToneId = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        defaultVolume,
        defaultToneId
      });
    }
    defaultVolume;
    defaultToneId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.defaultVolume, this.defaultToneId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "default volume": `${this.defaultVolume} %`,
          "default tone id": this.defaultToneId
        }
      };
    }
  };
  return SoundSwitchCCConfigurationSet2 = _classThis;
})();
let SoundSwitchCCConfigurationReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SoundSwitchCommand.ConfigurationReport), (0, import_CommandClassDecorators.ccValueProperty)("defaultVolume", import_CCValues_generated.SoundSwitchCCValues.defaultVolume), (0, import_CommandClassDecorators.ccValueProperty)("defaultToneId", import_CCValues_generated.SoundSwitchCCValues.defaultToneId)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SoundSwitchCC;
  var SoundSwitchCCConfigurationReport2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCConfigurationReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCConfigurationReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.defaultVolume = options.defaultVolume;
      this.defaultToneId = options.defaultToneId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const defaultVolume = (0, import_math.clamp)(raw.payload[0], 0, 100);
      const defaultToneId = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        defaultVolume,
        defaultToneId
      });
    }
    defaultVolume;
    defaultToneId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.defaultVolume, this.defaultToneId]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "default volume": `${this.defaultVolume} %`,
          "default tone id": this.defaultToneId
        }
      };
    }
  };
  return SoundSwitchCCConfigurationReport2 = _classThis;
})();
let SoundSwitchCCConfigurationGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SoundSwitchCommand.ConfigurationGet), (0, import_CommandClassDecorators.expectedCCResponse)(SoundSwitchCCConfigurationReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SoundSwitchCC;
  var SoundSwitchCCConfigurationGet2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCConfigurationGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCConfigurationGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SoundSwitchCCConfigurationGet2 = _classThis;
})();
let SoundSwitchCCTonePlaySet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SoundSwitchCommand.TonePlaySet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SoundSwitchCC;
  var SoundSwitchCCTonePlaySet2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCTonePlaySet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCTonePlaySet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.toneId = options.toneId;
      this.volume = options.volume;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const toneId = raw.payload[0];
      let volume;
      if (toneId !== 0 && raw.payload.length >= 2) {
        volume = raw.payload[1];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        toneId,
        volume
      });
    }
    toneId;
    volume;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.toneId, this.volume ?? 0]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "tone id": this.toneId
      };
      if (this.volume != void 0) {
        message.volume = this.volume === 0 ? "default" : `${this.volume} %`;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return SoundSwitchCCTonePlaySet2 = _classThis;
})();
let SoundSwitchCCTonePlayReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SoundSwitchCommand.TonePlayReport), (0, import_CommandClassDecorators.ccValueProperty)("toneId", import_CCValues_generated.SoundSwitchCCValues.toneId), (0, import_CommandClassDecorators.ccValueProperty)("volume", import_CCValues_generated.SoundSwitchCCValues.volume)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SoundSwitchCC;
  var SoundSwitchCCTonePlayReport2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCTonePlayReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCTonePlayReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.toneId = options.toneId;
      this.volume = options.volume;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const toneId = raw.payload[0];
      let volume;
      if (toneId !== 0 && raw.payload.length >= 2) {
        volume = raw.payload[1];
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        toneId,
        volume
      });
    }
    toneId;
    volume;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.toneId, this.volume ?? 0]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "tone id": this.toneId
      };
      if (this.volume != void 0) {
        message.volume = this.volume === 0 ? "default" : `${this.volume} %`;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return SoundSwitchCCTonePlayReport2 = _classThis;
})();
let SoundSwitchCCTonePlayGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.SoundSwitchCommand.TonePlayGet), (0, import_CommandClassDecorators.expectedCCResponse)(SoundSwitchCCTonePlayReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SoundSwitchCC;
  var SoundSwitchCCTonePlayGet2 = class extends _classSuper {
    static {
      __name(this, "SoundSwitchCCTonePlayGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SoundSwitchCCTonePlayGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SoundSwitchCCTonePlayGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SoundSwitchCC,
  SoundSwitchCCAPI,
  SoundSwitchCCConfigurationGet,
  SoundSwitchCCConfigurationReport,
  SoundSwitchCCConfigurationSet,
  SoundSwitchCCToneInfoGet,
  SoundSwitchCCToneInfoReport,
  SoundSwitchCCTonePlayGet,
  SoundSwitchCCTonePlayReport,
  SoundSwitchCCTonePlaySet,
  SoundSwitchCCTonesNumberGet,
  SoundSwitchCCTonesNumberReport,
  SoundSwitchCCValues
});
//# sourceMappingURL=SoundSwitchCC.js.map
