"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ThermostatModeCC_exports = {};
__export(ThermostatModeCC_exports, {
  ThermostatModeCC: () => ThermostatModeCC,
  ThermostatModeCCAPI: () => ThermostatModeCCAPI,
  ThermostatModeCCGet: () => ThermostatModeCCGet,
  ThermostatModeCCReport: () => ThermostatModeCCReport,
  ThermostatModeCCSet: () => ThermostatModeCCSet,
  ThermostatModeCCSupportedGet: () => ThermostatModeCCSupportedGet,
  ThermostatModeCCSupportedReport: () => ThermostatModeCCSupportedReport,
  ThermostatModeCCValues: () => import_CCValues_generated.ThermostatModeCCValues
});
module.exports = __toCommonJS(ThermostatModeCC_exports);
var __validateArgs = __toESM(require("./ThermostatModeCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ThermostatModeCCAPI_set } = __validateArgs;
let ThermostatModeCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Thermostat Mode"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  var ThermostatModeCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ThermostatModeCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_ThermostatModeCCAPI_set({ strictEnums: true })];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatModeCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ThermostatModeCommand.Get:
        case import_Types.ThermostatModeCommand.SupportedGet:
          return this.isSinglecast();
        case import_Types.ThermostatModeCommand.Set:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property }, value) {
        if (property !== "mode") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (typeof value !== "number") {
          (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
        }
        const result = await this.set(value);
        if (this.isSinglecast() && !(0, import_core.supervisedCommandSucceeded)(result)) {
          this.schedulePoll({ property }, value);
        }
        return result;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "mode":
            return (await this.get())?.[property];
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.ThermostatModeCommand, import_Types.ThermostatModeCommand.Get);
      const cc = new ThermostatModeCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["mode", "manufacturerData"]);
      }
    }
    async set(mode, manufacturerData) {
      this.assertSupportsCommand(import_Types.ThermostatModeCommand, import_Types.ThermostatModeCommand.Set);
      if (typeof manufacturerData === "string") {
        if (manufacturerData.length % 2 !== 0 || !/^[0-9a-f]+$/i.test(manufacturerData)) {
          throw new import_core.ZWaveError(`Manufacturer data must be represented as hexadecimal when passed as a string!`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        manufacturerData = import_shared.Bytes.from(manufacturerData, "hex");
      }
      const cc = new ThermostatModeCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        mode,
        manufacturerData
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getSupportedModes() {
      this.assertSupportsCommand(import_Types.ThermostatModeCommand, import_Types.ThermostatModeCommand.SupportedGet);
      const cc = new ThermostatModeCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedModes;
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ThermostatModeCCAPI2 = _classThis;
})();
let ThermostatModeCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Thermostat Mode"]), (0, import_CommandClassDecorators.implementedVersion)(3), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.ThermostatModeCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ThermostatModeCC2 = class extends _classSuper {
    static {
      __name(this, "ThermostatModeCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatModeCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Thermostat Mode"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying supported thermostat modes...",
        direction: "outbound"
      });
      const supportedModes = await api.getSupportedModes();
      if (supportedModes) {
        const logMessage = `received supported thermostat modes:${supportedModes.map((mode) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.ThermostatMode, mode)}`).join("")}`;
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying supported thermostat modes timed out, skipping interview...",
          level: "warn"
        });
        return;
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Thermostat Mode"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying current thermostat mode...",
        direction: "outbound"
      });
      const currentStatus = await api.get();
      if (currentStatus) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "received current thermostat mode: " + (0, import_shared.getEnumMemberName)(import_Types.ThermostatMode, currentStatus.mode),
          direction: "inbound"
        });
      }
    }
  };
  return ThermostatModeCC2 = _classThis;
})();
let ThermostatModeCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatModeCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatModeCC;
  var ThermostatModeCCSet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatModeCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatModeCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.mode = options.mode;
      if ("manufacturerData" in options) {
        this.manufacturerData = options.manufacturerData;
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const mode = raw.payload[0] & 31;
      if (mode !== import_Types.ThermostatMode["Manufacturer specific"]) {
        return new this({
          nodeId: ctx.sourceNodeId,
          mode
        });
      }
      const manufacturerDataLength = raw.payload[0] >>> 5 & 7;
      (0, import_core.validatePayload)(raw.payload.length >= 1 + manufacturerDataLength);
      const manufacturerData = raw.payload.subarray(1, 1 + manufacturerDataLength);
      return new this({
        nodeId: ctx.sourceNodeId,
        mode,
        manufacturerData
      });
    }
    mode;
    manufacturerData;
    serialize(ctx) {
      const manufacturerData = this.mode === import_Types.ThermostatMode["Manufacturer specific"] && this.manufacturerData ? this.manufacturerData : new Uint8Array();
      const manufacturerDataLength = manufacturerData.length;
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([
          ((manufacturerDataLength & 7) << 5) + (this.mode & 31)
        ]),
        manufacturerData
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        mode: (0, import_shared.getEnumMemberName)(import_Types.ThermostatMode, this.mode)
      };
      if (this.manufacturerData != void 0) {
        message["manufacturer data"] = (0, import_shared.buffer2hex)(this.manufacturerData);
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ThermostatModeCCSet2 = _classThis;
})();
let ThermostatModeCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatModeCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("mode", import_CCValues_generated.ThermostatModeCCValues.thermostatMode), (0, import_CommandClassDecorators.ccValueProperty)("manufacturerData", import_CCValues_generated.ThermostatModeCCValues.manufacturerData)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatModeCC;
  var ThermostatModeCCReport2 = class extends _classSuper {
    static {
      __name(this, "ThermostatModeCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatModeCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.mode = options.mode;
      this.manufacturerData = options.manufacturerData;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const mode = raw.payload[0] & 31;
      if (mode !== import_Types.ThermostatMode["Manufacturer specific"]) {
        return new this({
          nodeId: ctx.sourceNodeId,
          mode
        });
      }
      const manufacturerDataLength = raw.payload[0] >>> 5;
      (0, import_core.validatePayload)(raw.payload.length >= 1 + manufacturerDataLength);
      const manufacturerData = raw.payload.subarray(1, 1 + manufacturerDataLength);
      return new this({
        nodeId: ctx.sourceNodeId,
        mode,
        manufacturerData
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const thermostatModeValue = import_CCValues_generated.ThermostatModeCCValues.thermostatMode;
      const supportedModesValue = import_CCValues_generated.ThermostatModeCCValues.supportedModes;
      const supportedModes = this.getValue(ctx, supportedModesValue);
      if (supportedModes && this.mode in import_Types.ThermostatMode && !supportedModes.includes(this.mode)) {
        supportedModes.push(this.mode);
        supportedModes.sort((a, b) => a - b);
        this.setMetadata(ctx, thermostatModeValue, {
          ...thermostatModeValue.meta,
          states: (0, import_core.enumValuesToMetadataStates)(import_Types.ThermostatMode, supportedModes)
        });
        this.setValue(ctx, supportedModesValue, supportedModes);
      }
      return true;
    }
    mode;
    manufacturerData;
    serialize(ctx) {
      const manufacturerDataLength = this.mode === import_Types.ThermostatMode["Manufacturer specific"] && this.manufacturerData ? Math.min(7, this.manufacturerData.length) : 0;
      this.payload = new import_shared.Bytes(1 + manufacturerDataLength);
      this.payload[0] = (manufacturerDataLength << 5) + (this.mode & 31);
      if (manufacturerDataLength && this.manufacturerData) {
        this.payload.set(this.manufacturerData.subarray(0, manufacturerDataLength), 1);
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        mode: (0, import_shared.getEnumMemberName)(import_Types.ThermostatMode, this.mode)
      };
      if (this.manufacturerData != void 0) {
        message["manufacturer data"] = (0, import_shared.buffer2hex)(this.manufacturerData);
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ThermostatModeCCReport2 = _classThis;
})();
let ThermostatModeCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatModeCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ThermostatModeCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatModeCC;
  var ThermostatModeCCGet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatModeCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatModeCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ThermostatModeCCGet2 = _classThis;
})();
let ThermostatModeCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatModeCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedModes", import_CCValues_generated.ThermostatModeCCValues.supportedModes)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatModeCC;
  var ThermostatModeCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "ThermostatModeCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatModeCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedModes = options.supportedModes;
    }
    static from(raw, ctx) {
      const supportedModes = (0, import_core.parseBitMask)(raw.payload, import_Types.ThermostatMode.Off);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedModes
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const thermostatModeValue = import_CCValues_generated.ThermostatModeCCValues.thermostatMode;
      this.setMetadata(ctx, thermostatModeValue, {
        ...thermostatModeValue.meta,
        states: (0, import_core.enumValuesToMetadataStates)(import_Types.ThermostatMode, this.supportedModes)
      });
      return true;
    }
    supportedModes;
    serialize(ctx) {
      this.payload = (0, import_core.encodeBitMask)(this.supportedModes, import_Types.ThermostatMode["Manufacturer specific"], import_Types.ThermostatMode.Off);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported modes": this.supportedModes.map((mode) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.ThermostatMode, mode)}`).join("")
        }
      };
    }
  };
  return ThermostatModeCCSupportedReport2 = _classThis;
})();
let ThermostatModeCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ThermostatModeCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(ThermostatModeCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ThermostatModeCC;
  var ThermostatModeCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "ThermostatModeCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ThermostatModeCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ThermostatModeCCSupportedGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ThermostatModeCC,
  ThermostatModeCCAPI,
  ThermostatModeCCGet,
  ThermostatModeCCReport,
  ThermostatModeCCSet,
  ThermostatModeCCSupportedGet,
  ThermostatModeCCSupportedReport,
  ThermostatModeCCValues
});
//# sourceMappingURL=ThermostatModeCC.js.map
