"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var FibaroCC_exports = {};
__export(FibaroCC_exports, {
  FibaroCC: () => FibaroCC,
  FibaroCCAPI: () => FibaroCCAPI,
  FibaroCCIDs: () => FibaroCCIDs,
  FibaroVenetianBlindCC: () => FibaroVenetianBlindCC,
  FibaroVenetianBlindCCCommand: () => FibaroVenetianBlindCCCommand,
  FibaroVenetianBlindCCGet: () => FibaroVenetianBlindCCGet,
  FibaroVenetianBlindCCReport: () => FibaroVenetianBlindCCReport,
  FibaroVenetianBlindCCSet: () => FibaroVenetianBlindCCSet,
  MANUFACTURERID_FIBARO: () => MANUFACTURERID_FIBARO,
  getFibaroVenetianBlindPositionMetadata: () => getFibaroVenetianBlindPositionMetadata,
  getFibaroVenetianBlindPositionValueId: () => getFibaroVenetianBlindPositionValueId,
  getFibaroVenetianBlindTiltMetadata: () => getFibaroVenetianBlindTiltMetadata,
  getFibaroVenetianBlindTiltValueId: () => getFibaroVenetianBlindTiltValueId
});
module.exports = __toCommonJS(FibaroCC_exports);
var __validateArgs = __toESM(require("./FibaroCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_API = require("../../lib/API.js");
var import_CommandClassDecorators = require("../../lib/CommandClassDecorators.js");
var import_ManufacturerProprietaryCC = require("../ManufacturerProprietaryCC.js");
var import_Decorators = require("./Decorators.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_FibaroCCAPI_fibaroVenetianBlindsSetPosition, validateArgs_FibaroCCAPI_fibaroVenetianBlindsSetTilt } = __validateArgs;
const MANUFACTURERID_FIBARO = 271;
function getFibaroVenetianBlindPositionValueId(endpoint) {
  return {
    commandClass: import_core.CommandClasses["Manufacturer Proprietary"],
    endpoint,
    property: "fibaro",
    propertyKey: "venetianBlindsPosition"
  };
}
__name(getFibaroVenetianBlindPositionValueId, "getFibaroVenetianBlindPositionValueId");
function getFibaroVenetianBlindPositionMetadata() {
  return {
    ...import_core.ValueMetadata.Level,
    label: "Venetian blinds position"
  };
}
__name(getFibaroVenetianBlindPositionMetadata, "getFibaroVenetianBlindPositionMetadata");
function getFibaroVenetianBlindTiltValueId(endpoint) {
  return {
    commandClass: import_core.CommandClasses["Manufacturer Proprietary"],
    endpoint,
    property: "fibaro",
    propertyKey: "venetianBlindsTilt"
  };
}
__name(getFibaroVenetianBlindTiltValueId, "getFibaroVenetianBlindTiltValueId");
function getFibaroVenetianBlindTiltMetadata() {
  return {
    ...import_core.ValueMetadata.Level,
    label: "Venetian blinds tilt"
  };
}
__name(getFibaroVenetianBlindTiltMetadata, "getFibaroVenetianBlindTiltMetadata");
function getSupportedFibaroCCIDs(ctx, nodeId) {
  const proprietaryConfig = ctx.getDeviceConfig?.(nodeId)?.proprietary;
  if (proprietaryConfig && (0, import_typeguards.isArray)(proprietaryConfig.fibaroCCs)) {
    return proprietaryConfig.fibaroCCs;
  }
  return [];
}
__name(getSupportedFibaroCCIDs, "getSupportedFibaroCCIDs");
var FibaroCCIDs;
(function(FibaroCCIDs2) {
  FibaroCCIDs2[FibaroCCIDs2["VenetianBlind"] = 38] = "VenetianBlind";
})(FibaroCCIDs || (FibaroCCIDs = {}));
let FibaroCCAPI = (() => {
  let _classDecorators = [(0, import_Decorators.manufacturerProprietaryAPI)(MANUFACTURERID_FIBARO)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_ManufacturerProprietaryCC.ManufacturerProprietaryCCAPI;
  let _instanceExtraInitializers = [];
  let _fibaroVenetianBlindsSetPosition_decorators;
  let _fibaroVenetianBlindsSetTilt_decorators;
  var FibaroCCAPI2 = class extends _classSuper {
    static {
      __name(this, "FibaroCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(this, null, _fibaroVenetianBlindsSetPosition_decorators, { kind: "method", name: "fibaroVenetianBlindsSetPosition", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "fibaroVenetianBlindsSetPosition" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.fibaroVenetianBlindsSetPosition, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _fibaroVenetianBlindsSetTilt_decorators, { kind: "method", name: "fibaroVenetianBlindsSetTilt", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "fibaroVenetianBlindsSetTilt" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.fibaroVenetianBlindsSetTilt, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FibaroCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    async fibaroVenetianBlindsGet() {
      const cc = new FibaroVenetianBlindCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["position", "tilt"]);
      }
    }
    async fibaroVenetianBlindsSetPosition(value) {
      const cc = new FibaroVenetianBlindCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        position: value
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async fibaroVenetianBlindsSetTilt(value) {
      const cc = new FibaroVenetianBlindCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        tilt: value
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    get [(_fibaroVenetianBlindsSetPosition_decorators = [validateArgs_FibaroCCAPI_fibaroVenetianBlindsSetPosition()], _fibaroVenetianBlindsSetTilt_decorators = [validateArgs_FibaroCCAPI_fibaroVenetianBlindsSetTilt()], import_API.SET_VALUE)]() {
      return async function({ property, propertyKey }, value) {
        if (property !== "fibaro") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (propertyKey === "venetianBlindsPosition") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          await this.fibaroVenetianBlindsSetPosition(value);
        } else if (propertyKey === "venetianBlindsTilt") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          await this.fibaroVenetianBlindsSetTilt(value);
        } else {
          return;
        }
        this.schedulePoll({ property, propertyKey }, value);
        return void 0;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        if (property !== "fibaro") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        } else if (propertyKey == void 0) {
          (0, import_API.throwMissingPropertyKey)(this.ccId, property);
        }
        switch (propertyKey) {
          case "venetianBlindsPosition":
            return (await this.fibaroVenetianBlindsGet())?.position;
          case "venetianBlindsTilt":
            return (await this.fibaroVenetianBlindsGet())?.tilt;
          default:
            (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
        }
      };
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return FibaroCCAPI2 = _classThis;
})();
let FibaroCC = (() => {
  let _classDecorators = [(0, import_Decorators.manufacturerId)(MANUFACTURERID_FIBARO)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_ManufacturerProprietaryCC.ManufacturerProprietaryCC;
  var FibaroCC2 = class extends _classSuper {
    static {
      __name(this, "FibaroCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FibaroCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.fibaroCCId = (0, import_Decorators.getFibaroCCId)(this);
      this.fibaroCCCommand = (0, import_Decorators.getFibaroCCCommand)(this);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const fibaroCCId = raw.payload[0];
      const fibaroCCCommand2 = raw.payload[1];
      const FibaroConstructor = (0, import_Decorators.getFibaroCCCommandConstructor)(fibaroCCId, fibaroCCCommand2);
      if (FibaroConstructor) {
        return FibaroConstructor.from(raw.withPayload(raw.payload.subarray(2)), ctx);
      }
      return new FibaroCC2({
        nodeId: ctx.sourceNodeId
      });
    }
    fibaroCCId;
    fibaroCCCommand;
    async interview(ctx) {
      const node = this.getNode(ctx);
      const supportedFibaroCCIDs = getSupportedFibaroCCIDs(ctx, node.id);
      for (const ccId of supportedFibaroCCIDs) {
        const SubConstructor = (0, import_Decorators.getFibaroCCConstructor)(ccId);
        if (SubConstructor) {
          const instance = new SubConstructor({ nodeId: node.id });
          await instance.interview(ctx);
        }
      }
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const supportedFibaroCCIDs = getSupportedFibaroCCIDs(ctx, node.id);
      for (const ccId of supportedFibaroCCIDs) {
        const SubConstructor = (0, import_Decorators.getFibaroCCConstructor)(ccId);
        if (SubConstructor) {
          const instance = new SubConstructor({ nodeId: node.id });
          await instance.refreshValues(ctx);
        }
      }
    }
    serialize(ctx) {
      if (this.fibaroCCId == void 0) {
        throw new import_core.ZWaveError("Cannot serialize a Fibaro CC without a Fibaro CC ID", import_core.ZWaveErrorCodes.CC_Invalid);
      } else if (this.fibaroCCCommand == void 0) {
        throw new import_core.ZWaveError("Cannot serialize a Fibaro CC without a Fibaro CC Command", import_core.ZWaveErrorCodes.CC_Invalid);
      }
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.fibaroCCId, this.fibaroCCCommand]),
        this.payload
      ]);
      return super.serialize(ctx);
    }
  };
  return FibaroCC2 = _classThis;
})();
var FibaroVenetianBlindCCCommand;
(function(FibaroVenetianBlindCCCommand2) {
  FibaroVenetianBlindCCCommand2[FibaroVenetianBlindCCCommand2["Set"] = 1] = "Set";
  FibaroVenetianBlindCCCommand2[FibaroVenetianBlindCCCommand2["Get"] = 2] = "Get";
  FibaroVenetianBlindCCCommand2[FibaroVenetianBlindCCCommand2["Report"] = 3] = "Report";
})(FibaroVenetianBlindCCCommand || (FibaroVenetianBlindCCCommand = {}));
let FibaroVenetianBlindCC = (() => {
  let _classDecorators = [(0, import_Decorators.fibaroCC)(FibaroCCIDs.VenetianBlind)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FibaroCC;
  var FibaroVenetianBlindCC2 = class extends _classSuper {
    static {
      __name(this, "FibaroVenetianBlindCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FibaroVenetianBlindCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.fibaroCCId = FibaroCCIDs.VenetianBlind;
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing Fibaro Venetian Blind CC...`,
        direction: "none"
      });
      await this.refreshValues(ctx);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      ctx.logNode(node.id, {
        message: "Requesting venetian blind position and tilt...",
        direction: "outbound"
      });
      const resp = await ctx.sendCommand(new FibaroVenetianBlindCCGet({
        nodeId: this.nodeId,
        endpointIndex: this.endpointIndex
      }));
      if (resp) {
        const logMessage = `received venetian blind state:
position: ${resp.position}
tilt:     ${resp.tilt}`;
        ctx.logNode(node.id, {
          message: logMessage,
          direction: "inbound"
        });
      }
    }
  };
  return FibaroVenetianBlindCC2 = _classThis;
})();
let FibaroVenetianBlindCCSet = (() => {
  let _classDecorators = [(0, import_Decorators.fibaroCCCommand)(FibaroVenetianBlindCCCommand.Set)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FibaroVenetianBlindCC;
  var FibaroVenetianBlindCCSet2 = class extends _classSuper {
    static {
      __name(this, "FibaroVenetianBlindCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FibaroVenetianBlindCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.fibaroCCCommand = FibaroVenetianBlindCCCommand.Set;
      if ("position" in options)
        this.position = options.position;
      if ("tilt" in options)
        this.tilt = options.tilt;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    position;
    tilt;
    serialize(ctx) {
      const controlByte = (this.position != void 0 ? 2 : 0) | (this.tilt != void 0 ? 1 : 0);
      this.payload = import_shared.Bytes.from([
        controlByte,
        this.position ?? 0,
        this.tilt ?? 0
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {};
      if (this.position != void 0) {
        message.position = this.position;
      }
      if (this.tilt != void 0) {
        message.tilt = this.tilt;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return FibaroVenetianBlindCCSet2 = _classThis;
})();
let FibaroVenetianBlindCCReport = (() => {
  let _classDecorators = [(0, import_Decorators.fibaroCCCommand)(FibaroVenetianBlindCCCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FibaroVenetianBlindCC;
  var FibaroVenetianBlindCCReport2 = class extends _classSuper {
    static {
      __name(this, "FibaroVenetianBlindCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FibaroVenetianBlindCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.fibaroCCCommand = FibaroVenetianBlindCCCommand.Report;
      this.position = options.position;
      this.tilt = options.tilt;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      let position;
      if (!!(raw.payload[0] & 2)) {
        position = (0, import_core.parseMaybeNumber)(raw.payload[1]);
      }
      let tilt;
      if (!!(raw.payload[0] & 1)) {
        tilt = (0, import_core.parseMaybeNumber)(raw.payload[2]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        position,
        tilt
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const valueDB = this.getValueDB(ctx);
      if (this.position != void 0) {
        const positionValueId = getFibaroVenetianBlindPositionValueId(this.endpointIndex);
        valueDB.setMetadata(positionValueId, {
          ...import_core.ValueMetadata.Level,
          label: "Venetian blinds position"
        });
        valueDB.setValue(positionValueId, this.position);
      }
      if (this.tilt != void 0) {
        const tiltValueId = getFibaroVenetianBlindTiltValueId(this.endpointIndex);
        valueDB.setMetadata(tiltValueId, {
          ...import_core.ValueMetadata.Level,
          label: "Venetian blinds tilt"
        });
        valueDB.setValue(tiltValueId, this.tilt);
      }
      return true;
    }
    position;
    tilt;
    toLogEntry(ctx) {
      const message = {};
      if (this.position != void 0) {
        message.position = this.position;
      }
      if (this.tilt != void 0) {
        message.tilt = this.tilt;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return FibaroVenetianBlindCCReport2 = _classThis;
})();
let FibaroVenetianBlindCCGet = (() => {
  let _classDecorators = [(0, import_Decorators.fibaroCCCommand)(FibaroVenetianBlindCCCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(FibaroVenetianBlindCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FibaroVenetianBlindCC;
  var FibaroVenetianBlindCCGet2 = class extends _classSuper {
    static {
      __name(this, "FibaroVenetianBlindCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FibaroVenetianBlindCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    // @noLogEntry: This CC has no properties to log
    constructor(options) {
      super(options);
      this.fibaroCCCommand = FibaroVenetianBlindCCCommand.Get;
    }
    static from(raw, ctx) {
      return new this({
        nodeId: ctx.sourceNodeId
      });
    }
  };
  return FibaroVenetianBlindCCGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  FibaroCC,
  FibaroCCAPI,
  FibaroCCIDs,
  FibaroVenetianBlindCC,
  FibaroVenetianBlindCCCommand,
  FibaroVenetianBlindCCGet,
  FibaroVenetianBlindCCReport,
  FibaroVenetianBlindCCSet,
  MANUFACTURERID_FIBARO,
  getFibaroVenetianBlindPositionMetadata,
  getFibaroVenetianBlindPositionValueId,
  getFibaroVenetianBlindTiltMetadata,
  getFibaroVenetianBlindTiltValueId
});
//# sourceMappingURL=FibaroCC.js.map
