"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Values_exports = {};
__export(Values_exports, {
  V: () => V,
  defaultCCValueOptions: () => defaultCCValueOptions
});
module.exports = __toCommonJS(Values_exports);
var import_shared = require("@zwave-js/shared");
var import_CCValues_generated = require("../cc/_CCValues.generated.js");
function defineCCValues(commandClass, _) {
  return import_CCValues_generated.CCValues[commandClass];
}
__name(defineCCValues, "defineCCValues");
const defaultCCValueOptions = {
  internal: false,
  minVersion: 1,
  secret: false,
  stateful: true,
  supportsEndpoints: true,
  autoCreate: true
};
const V = {
  /** Returns a CC value definition that is named like the value `property` */
  staticProperty(property, meta, options) {
    return {
      [property]: {
        property,
        meta,
        options
      }
    };
  },
  /** Returns a CC value definition with the given name and `property` */
  staticPropertyWithName(name, property, meta, options) {
    return {
      [name]: {
        property,
        meta,
        options
      }
    };
  },
  /** Returns a CC value definition with the given name, `property` and `propertyKey` */
  staticPropertyAndKeyWithName(name, property, propertyKey, meta, options) {
    return {
      [name]: {
        property,
        propertyKey,
        meta,
        options
      }
    };
  },
  /** Returns a CC value definition with the given name and a dynamic `property` */
  dynamicPropertyWithName(name, property, is, meta, options) {
    return {
      [name]: Object.assign((...args) => ({
        property: (0, import_shared.evalOrStatic)(property, ...args),
        meta: (0, import_shared.evalOrStatic)(meta, ...args)
      }), { is, options })
    };
  },
  /** Returns a CC value definition with the given name and a dynamic `property` */
  dynamicPropertyAndKeyWithName(name, property, propertyKey, is, meta, options) {
    return {
      [name]: Object.assign((...args) => {
        return {
          property: (0, import_shared.evalOrStatic)(property, ...args),
          propertyKey: (0, import_shared.evalOrStatic)(propertyKey, ...args),
          meta: (0, import_shared.evalOrStatic)(meta, ...args)
        };
      }, { is, options })
    };
  },
  defineCCValues
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  V,
  defaultCCValueOptions
});
//# sourceMappingURL=Values.js.map
