"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var serializers_exports = {};
__export(serializers_exports, {
  decodeSetbackState: () => decodeSetbackState,
  decodeSwitchpoint: () => decodeSwitchpoint,
  encodeSetbackState: () => encodeSetbackState,
  encodeSwitchpoint: () => encodeSwitchpoint,
  encodeTimezone: () => encodeTimezone,
  parseTimezone: () => parseTimezone,
  setbackSpecialStateValues: () => setbackSpecialStateValues
});
module.exports = __toCommonJS(serializers_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_math = require("alcalzone-shared/math");
const setbackSpecialStateValues = {
  "Frost Protection": 121,
  "Energy Saving": 122,
  Unused: 127
};
function encodeSetbackState(state) {
  let rawValue;
  if (typeof state === "string") {
    rawValue = setbackSpecialStateValues[state];
  } else {
    state = (0, import_math.clamp)(state, -12.8, 12);
    rawValue = Math.round(state * 10);
  }
  const ret = new import_shared.Bytes(1);
  ret.writeInt8(rawValue);
  return ret;
}
__name(encodeSetbackState, "encodeSetbackState");
function decodeSetbackState(data, offset = 0) {
  const val = import_shared.Bytes.view(data).readInt8(offset);
  if (val > 120) {
    const foundEntry = Object.entries(setbackSpecialStateValues).find(([, v]) => val === v);
    if (!foundEntry)
      return;
    return foundEntry[0];
  } else {
    return val / 10;
  }
}
__name(decodeSetbackState, "decodeSetbackState");
function decodeSwitchpoint(data) {
  return {
    hour: data[0] & 31,
    minute: data[1] & 63,
    state: decodeSetbackState(data, 2)
  };
}
__name(decodeSwitchpoint, "decodeSwitchpoint");
function encodeSwitchpoint(point) {
  if (point.state == void 0) {
    throw new import_core.ZWaveError("The given Switchpoint is not valid!", import_core.ZWaveErrorCodes.CC_Invalid);
  }
  return import_shared.Bytes.concat([
    [
      point.hour & 31,
      point.minute & 63
    ],
    encodeSetbackState(point.state)
  ]);
}
__name(encodeSwitchpoint, "encodeSwitchpoint");
function parseTimezone(data) {
  const hourSign = !!(data[0] & 128);
  const hour = data[0] & 127;
  const minute = data[1];
  const standardOffset = (hourSign ? -1 : 1) * (hour * 60 + minute);
  const deltaSign = !!(data[2] & 128);
  const deltaMinutes = data[2] & 127;
  const dstOffset = standardOffset + (deltaSign ? -1 : 1) * deltaMinutes;
  return {
    standardOffset,
    dstOffset
  };
}
__name(parseTimezone, "parseTimezone");
function encodeTimezone(tz) {
  if (Math.abs(tz.standardOffset) >= 24 * 60 || Math.abs(tz.dstOffset) >= 24 * 60) {
    throw new import_core.ZWaveError("The given timezone is not valid!", import_core.ZWaveErrorCodes.CC_Invalid);
  }
  const minutes = Math.abs(tz.standardOffset) % 60;
  const hour = Math.floor(Math.abs(tz.standardOffset) / 60);
  const hourSign = tz.standardOffset < 0 ? 1 : 0;
  const delta = tz.dstOffset - tz.standardOffset;
  const deltaMinutes = Math.abs(delta);
  const deltaSign = delta < 0 ? 1 : 0;
  return import_shared.Bytes.from([
    hourSign << 7 | hour & 127,
    minutes,
    deltaSign << 7 | deltaMinutes & 127
  ]);
}
__name(encodeTimezone, "encodeTimezone");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  decodeSetbackState,
  decodeSwitchpoint,
  encodeSetbackState,
  encodeSwitchpoint,
  encodeTimezone,
  parseTimezone,
  setbackSpecialStateValues
});
//# sourceMappingURL=serializers.js.map
