import * as v from "@zwave-js/core/validation";
export function validateArgs_IndicatorCCAPI_get() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function get(indicatorId) {
                v.assert(v.optional({ kind: "parameter", name: "indicatorId" }, v.primitive({ kind: "parameter", name: "indicatorId" }, "number"))(indicatorId));
                return __decoratedMethod.call(this, indicatorId);
            };
        }
    };
}
export function validateArgs_IndicatorCCAPI_set() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function set(value) {
                v.assert(v.oneOf({ kind: "parameter", name: "value" }, undefined, v.primitive({ kind: "parameter", name: "value" }, "number"), v.array({ kind: "parameter", name: "value" }, 'IndicatorObject', v.object({ kind: "item", name: "value" }, 'IndicatorObject', { "indicatorId": v.primitive({ kind: "property", name: "indicatorId" }, "number"), "propertyId": v.primitive({ kind: "property", name: "propertyId" }, "number"), "value": v.oneOf({ kind: "property", name: "value" }, undefined, v.primitive({ kind: "property", name: "value" }, "number"), v.primitive({ kind: "property", name: "value" }, "boolean")) })))(value));
                return __decoratedMethod.call(this, value);
            };
        }
    };
}
export function validateArgs_IndicatorCCAPI_sendReport() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function sendReport(options) {
                v.assert(v.oneOf({ kind: "parameter", name: "options" }, "IndicatorCCReportOptions", v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "value": v.primitive({ kind: "property", name: "value" }, "number") }), v.object({ kind: "parameter", name: "options" }, '<anonymous object>', { "values": v.array({ kind: "property", name: "values" }, 'IndicatorObject', v.object({ kind: "item", name: "values" }, 'IndicatorObject', { "indicatorId": v.primitive({ kind: "property", name: "indicatorId" }, "number"), "propertyId": v.primitive({ kind: "property", name: "propertyId" }, "number"), "value": v.oneOf({ kind: "property", name: "value" }, undefined, v.primitive({ kind: "property", name: "value" }, "number"), v.primitive({ kind: "property", name: "value" }, "boolean")) })) }))(options));
                return __decoratedMethod.call(this, options);
            };
        }
    };
}
export function validateArgs_IndicatorCCAPI_getSupported() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getSupported(indicatorId) {
                v.assert(v.primitive({ kind: "parameter", name: "indicatorId" }, "number")(indicatorId));
                return __decoratedMethod.call(this, indicatorId);
            };
        }
    };
}
export function validateArgs_IndicatorCCAPI_reportSupported() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportSupported(indicatorId, supportedProperties, nextIndicatorId) {
                v.assert(v.primitive({ kind: "parameter", name: "indicatorId" }, "number")(indicatorId), v.array({ kind: "parameter", name: "supportedProperties" }, 'number', v.primitive({ kind: "item", name: "supportedProperties" }, "number"))(supportedProperties), v.primitive({ kind: "parameter", name: "nextIndicatorId" }, "number")(nextIndicatorId));
                return __decoratedMethod.call(this, indicatorId, supportedProperties, nextIndicatorId);
            };
        }
    };
}
export function validateArgs_IndicatorCCAPI_reportDescription() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function reportDescription(indicatorId, description) {
                v.assert(v.primitive({ kind: "parameter", name: "indicatorId" }, "number")(indicatorId), v.primitive({ kind: "parameter", name: "description" }, "string")(description));
                return __decoratedMethod.call(this, indicatorId, description);
            };
        }
    };
}
export function validateArgs_IndicatorCCAPI_setTimeout() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function setTimeout(indicatorId, timeout) {
                v.assert(v.primitive({ kind: "parameter", name: "indicatorId" }, "number")(indicatorId), v.optional({ kind: "parameter", name: "timeout" }, v.oneOf({ kind: "parameter", name: "timeout" }, undefined, v.primitive({ kind: "parameter", name: "timeout" }, "string"), v.object({ kind: "parameter", name: "timeout" }, 'IndicatorTimeout', { "hours": v.optional({ kind: "property", name: "hours" }, v.primitive({ kind: "property", name: "hours" }, "number")), "minutes": v.optional({ kind: "property", name: "minutes" }, v.primitive({ kind: "property", name: "minutes" }, "number")), "seconds": v.optional({ kind: "property", name: "seconds" }, v.primitive({ kind: "property", name: "seconds" }, "number")) })))(timeout));
                return __decoratedMethod.call(this, indicatorId, timeout);
            };
        }
    };
}
export function validateArgs_IndicatorCCAPI_getTimeout() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getTimeout(indicatorId) {
                v.assert(v.primitive({ kind: "parameter", name: "indicatorId" }, "number")(indicatorId));
                return __decoratedMethod.call(this, indicatorId);
            };
        }
    };
}
export function validateArgs_IndicatorCCAPI_getDescription() {
    return (__decoratedMethod, { kind }) => {
        if (kind === "method") {
            return function getDescription(indicatorId) {
                v.assert(v.primitive({ kind: "parameter", name: "indicatorId" }, "number")(indicatorId));
                return __decoratedMethod.call(this, indicatorId);
            };
        }
    };
}
//# sourceMappingURL=IndicatorCC._validateArgs.js.map