import { type LogContainer } from "@zwave-js/core";
import type { FileSystem } from "@zwave-js/shared/bindings";
import { type ManufacturersMap } from "./Manufacturers.js";
import { ConditionalDeviceConfig, type DeviceConfig, type DeviceConfigIndex, type FulltextDeviceConfigIndex } from "./devices/DeviceConfig.js";
export interface ConfigManagerOptions {
    bindings?: FileSystem;
    logContainer?: LogContainer;
    deviceConfigPriorityDir?: string;
    deviceConfigExternalDir?: string;
}
export declare class ConfigManager {
    constructor(options?: ConfigManagerOptions);
    private _fs;
    private getFS;
    private _configVersion;
    get configVersion(): string;
    private _logContainer;
    private _logger;
    private getLogger;
    private _manufacturers;
    get manufacturers(): ManufacturersMap;
    private deviceConfigPriorityDir;
    private deviceConfigExternalDir;
    get externalConfigDir(): string | undefined;
    private index;
    private fulltextIndex;
    private _useExternalConfig;
    get useExternalConfig(): boolean;
    loadAll(): Promise<void>;
    loadManufacturers(): Promise<void>;
    saveManufacturers(): Promise<void>;
    /**
     * Looks up the name of the manufacturer with the given ID in the configuration DB
     * @param manufacturerId The manufacturer id to look up
     */
    lookupManufacturer(manufacturerId: number): string | undefined;
    /**
     * Add new manufacturers to configuration DB
     * @param manufacturerId The manufacturer id to look up
     * @param manufacturerName The manufacturer name
     */
    setManufacturer(manufacturerId: number, manufacturerName: string): void;
    loadDeviceIndex(): Promise<void>;
    getIndex(): DeviceConfigIndex | undefined;
    loadFulltextDeviceIndex(): Promise<void>;
    getFulltextIndex(): FulltextDeviceConfigIndex | undefined;
    /**
     * Looks up the definition of a given device in the configuration DB, but does not evaluate conditional settings.
     * @param manufacturerId The manufacturer id of the device
     * @param productType The product type of the device
     * @param productId The product id of the device
     * @param firmwareVersion If known, configuration for a specific firmware version can be loaded.
     * If this is `undefined` or not given, the first matching file with a defined firmware range will be returned.
     */
    lookupDevicePreserveConditions(manufacturerId: number, productType: number, productId: number, firmwareVersion?: string): Promise<ConditionalDeviceConfig | undefined>;
    /**
     * Looks up the definition of a given device in the configuration DB
     * @param manufacturerId The manufacturer id of the device
     * @param productType The product type of the device
     * @param productId The product id of the device
     * @param firmwareVersion If known, configuration for a specific firmware version can be loaded.
     * If this is `undefined` or not given, the first matching file with a defined firmware range will be returned.
     */
    lookupDevice(manufacturerId: number, productType: number, productId: number, firmwareVersion?: string): Promise<DeviceConfig | undefined>;
}
//# sourceMappingURL=ConfigManager.d.ts.map