"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Logic_exports = {};
__export(Logic_exports, {
  evaluate: () => evaluate,
  parseLogic: () => parseLogic
});
module.exports = __toCommonJS(Logic_exports);
var import_shared = require("@zwave-js/shared");
var import_eq = __toESM(require("semver/functions/eq.js"), 1);
var import_gt = __toESM(require("semver/functions/gt.js"), 1);
var import_gte = __toESM(require("semver/functions/gte.js"), 1);
var import_lt = __toESM(require("semver/functions/lt.js"), 1);
var import_lte = __toESM(require("semver/functions/lte.js"), 1);
var import_json_logic_js = __toESM(require("json-logic-js"), 1);
var import_LogicParser = require("./LogicParser.js");
const { add_operation, apply } = import_json_logic_js.default;
function tryOr(operation, onError) {
  return ((...args) => {
    try {
      return operation(...args);
    } catch {
      return onError;
    }
  });
}
__name(tryOr, "tryOr");
add_operation("ver >=", tryOr((a, b) => (0, import_gte.default)((0, import_shared.padVersion)(a), (0, import_shared.padVersion)(b)), false));
add_operation("ver >", tryOr((a, b) => (0, import_gt.default)((0, import_shared.padVersion)(a), (0, import_shared.padVersion)(b)), false));
add_operation("ver <=", tryOr((a, b) => (0, import_lte.default)((0, import_shared.padVersion)(a), (0, import_shared.padVersion)(b)), false));
add_operation("ver <", tryOr((a, b) => (0, import_lt.default)((0, import_shared.padVersion)(a), (0, import_shared.padVersion)(b)), false));
add_operation("ver ===", tryOr((a, b) => (0, import_eq.default)((0, import_shared.padVersion)(a), (0, import_shared.padVersion)(b)), false));
function parseLogic(input) {
  const expr = (0, import_LogicParser.parse)(input);
  if (!expr) {
    throw new Error(`Failed to parse expression: ${input}`);
  }
  return (0, import_LogicParser.toRulesLogic)(expr);
}
__name(parseLogic, "parseLogic");
function evaluate(logic, context) {
  const rules = parseLogic(logic);
  return apply(rules, context);
}
__name(evaluate, "evaluate");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  evaluate,
  parseLogic
});
//# sourceMappingURL=Logic.js.map
