import type { RulesLogic } from "json-logic-js";
export declare enum SyntaxKind {
    Group = 0,
    Or = 1,
    And = 2,
    Comparison = 3,
    Identifier = 4,
    NumberLiteral = 5,
    Version = 6
}
export declare enum Operator {
    Equal = 0,
    NotEqual = 1,
    LessThan = 2,
    LessThanOrEqual = 3,
    GreaterThan = 4,
    GreaterThanOrEqual = 5
}
export type Expression = Or | And | Comparison;
type Or = {
    kind: SyntaxKind.Or;
    operands: Expression[];
};
type And = {
    kind: SyntaxKind.And;
    operands: Expression[];
};
type Comparison = {
    kind: SyntaxKind.Comparison;
    left: Identifier;
    operator: Operator;
    right: NumberLiteral | Version;
};
type Identifier = {
    kind: SyntaxKind.Identifier;
    name: string;
};
type NumberLiteral = {
    kind: SyntaxKind.NumberLiteral;
    value: number;
};
type Version = {
    kind: SyntaxKind.Version;
    value: string;
};
export declare enum TokenKind {
    Identifier = 0,
    NumberLiteral = 1,
    Dot = 2,// "."
    LeftParen = 3,// "("
    RightParen = 4,// ")"
    BarBar = 5,// "||"
    AmpAmp = 6,// "&&"
    EqualsEquals = 7,// "=="
    EqualsEqualsEquals = 8,// "==="
    ExclamationEquals = 9,// "!="
    ExclamationEqualsEquals = 10,// "!=="
    LessThan = 11,// "<"
    LessThanEquals = 12,// "<="
    GreaterThan = 13,// ">"
    GreaterThanEquals = 14
}
export type Token = {
    start: number;
    kind: TokenKind;
    value?: string;
};
/**
 * Splits a string into tokens to be consumed by the Parser.
 */
export declare function tokenize(input: string): Generator<Token>;
export declare function parse(input: string): Expression | undefined;
export declare function toRulesLogic(expr: Expression): RulesLogic;
export {};
//# sourceMappingURL=LogicParser.d.ts.map