import { ZWaveLoggerBase, getDirectionPrefix, } from "@zwave-js/core";
import { CONFIG_LABEL, CONFIG_LOGLEVEL, } from "./Logger_safe.js";
export class ConfigLogger extends ZWaveLoggerBase {
    constructor(loggers) {
        super(loggers, CONFIG_LABEL);
    }
    /**
     * Logs a message
     * @param msg The message to output
     */
    print(message, level) {
        const actualLevel = level || CONFIG_LOGLEVEL;
        if (!this.container.isLoglevelVisible(actualLevel))
            return;
        this.logger.log({
            level: actualLevel,
            message,
            direction: getDirectionPrefix("none"),
            context: { source: "config" },
        });
    }
}
//# sourceMappingURL=Logger.js.map