import type { JSONObject } from "@zwave-js/shared";
import { type AssociationConfig, ConditionalAssociationConfig } from "./AssociationConfig.js";
import { type ConditionalItem } from "./ConditionalItem.js";
import type { ConditionalDeviceConfig } from "./DeviceConfig.js";
import { type ConditionalParamInfoMap, type ParamInfoMap } from "./ParamInformation.js";
import type { DeviceID } from "./shared.js";
export declare class ConditionalEndpointConfig implements ConditionalItem<EndpointConfig> {
    constructor(parent: ConditionalDeviceConfig, index: number, definition: JSONObject);
    readonly index: number;
    readonly associations?: ReadonlyMap<number, ConditionalAssociationConfig>;
    readonly paramInformation?: ConditionalParamInfoMap;
    readonly condition?: string;
    readonly label?: string;
    evaluateCondition(deviceId?: DeviceID): EndpointConfig | undefined;
}
export type EndpointConfig = Omit<ConditionalEndpointConfig, "condition" | "evaluateCondition" | "associations" | "paramInformation"> & {
    associations?: Map<number, AssociationConfig> | undefined;
    paramInformation?: ParamInfoMap;
};
//# sourceMappingURL=EndpointConfig.d.ts.map