"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var browser_exports = {};
__export(browser_exports, {
  log: () => log
});
module.exports = __toCommonJS(browser_exports);
var import_ansi_colors = __toESM(require("ansi-colors"), 1);
var import_triple_beam = require("triple-beam");
var import_Colorizer = require("../../log/Colorizer.js");
var import_format = require("../../log/format.js");
var import_shared = require("../../log/shared.js");
import_ansi_colors.default.enabled = true;
function createLoggerFormat(channel, colorize, shortTimestamps) {
  const formats = [
    (0, import_format.label)(channel),
    shortTimestamps ? (0, import_format.timestamp)(import_shared.timestampFormatShort) : (0, import_format.timestamp)(import_shared.timestampFormat),
    import_format.formatLogMessage,
    colorize ? (0, import_Colorizer.colorizer)(false) : void 0,
    (0, import_format.printLogMessage)(shortTimestamps)
  ].filter((f) => f != void 0);
  return (0, import_format.combine)(...formats);
}
__name(createLoggerFormat, "createLoggerFormat");
class ConsoleLogContainer {
  static {
    __name(this, "ConsoleLogContainer");
  }
  #loggers = /* @__PURE__ */ new Map();
  updateConfiguration(_config) {
  }
  getConfiguration() {
    return {
      enabled: true,
      level: "debug",
      transports: [],
      logToFile: false,
      filename: "zwavejs.log",
      forceConsole: false,
      maxFiles: 0
    };
  }
  destroy() {
  }
  getLogger(label2) {
    if (!this.#loggers.has(label2)) {
      const format = createLoggerFormat(label2, true, false);
      this.#loggers.set(label2, {
        log: /* @__PURE__ */ __name((info) => {
          info = format.transform(info);
          if (info.level === "error") {
            console.error(info[import_triple_beam.MESSAGE]);
          } else {
            console.log(info[import_triple_beam.MESSAGE]);
          }
        }, "log")
      });
    }
    return this.#loggers.get(label2);
  }
  isLoglevelVisible(loglevel) {
    return loglevel !== "silly";
  }
  isNodeLoggingVisible(_nodeId) {
    return true;
  }
}
const log = /* @__PURE__ */ __name((_config) => new ConsoleLogContainer(), "log");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  log
});
//# sourceMappingURL=browser.js.map
