import { type BytesView } from "@zwave-js/shared";
declare const decryptAES128OFB: (ciphertext: BytesView, key: BytesView, iv: BytesView) => Promise<BytesView>, encryptAES128CBC: (plaintext: BytesView, key: BytesView, iv: BytesView) => Promise<BytesView>, encryptAES128ECB: (plaintext: BytesView, key: BytesView) => Promise<BytesView>, encryptAES128OFB: (plaintext: BytesView, key: BytesView, iv: BytesView) => Promise<BytesView>, encryptAES128CCM: (plaintext: BytesView, key: BytesView, iv: BytesView, additionalData: BytesView, authTagLength: number) => Promise<{
    ciphertext: BytesView;
    authTag: BytesView;
}>, decryptAES128CCM: (ciphertext: BytesView, key: BytesView, iv: BytesView, additionalData: BytesView, authTag: BytesView) => Promise<{
    plaintext: BytesView;
    authOK: boolean;
}>, decryptAES256CBC: (ciphertext: BytesView, key: BytesView, iv: BytesView) => Promise<BytesView>, randomBytes: (length: number) => BytesView, digest: (algorithm: "md5" | "sha-1" | "sha-256", data: BytesView) => Promise<BytesView>, generateECDHKeyPair: () => Promise<import("@zwave-js/shared/bindings").KeyPair>, deriveSharedECDHSecret: (keyPair: import("@zwave-js/shared/bindings").KeyPair) => Promise<BytesView>, keyPairFromRawECDHPrivateKey: (privateKey: BytesView) => Promise<import("@zwave-js/shared/bindings").KeyPair>;
export { decryptAES128CCM, decryptAES128OFB, decryptAES256CBC, deriveSharedECDHSecret, digest, encryptAES128CBC, encryptAES128CCM, encryptAES128ECB, encryptAES128OFB, generateECDHKeyPair, keyPairFromRawECDHPrivateKey, randomBytes, };
/** Computes a message authentication code for Security S0 (as described in SDS10865) */
export declare function computeMAC(authData: BytesView, key: BytesView, iv?: BytesView): Promise<BytesView>;
/** Computes a message authentication code for Security S2 (as described in SDS13783) */
export declare function computeCMAC(message: BytesView, key: BytesView): Promise<BytesView>;
/** Computes the Pseudo Random Key (PRK) used to derive auth, encryption and nonce keys */
export declare function computePRK(ecdhSharedSecret: BytesView, pubKeyA: BytesView, pubKeyB: BytesView): Promise<BytesView>;
/** Derives the temporary auth, encryption and nonce keys from the PRK */
export declare function deriveTempKeys(PRK: BytesView): Promise<{
    tempKeyCCM: BytesView;
    tempPersonalizationString: BytesView;
}>;
/** Derives the CCM, MPAN keys and the personalization string from the permanent network key (PNK) */
export declare function deriveNetworkKeys(PNK: BytesView): Promise<{
    keyCCM: BytesView;
    keyMPAN: BytesView;
    personalizationString: BytesView;
}>;
/** Computes the Pseudo Random Key (PRK) used to derive the mixed entropy input (MEI) for nonce generation */
export declare function computeNoncePRK(senderEI: BytesView, receiverEI: BytesView): Promise<BytesView>;
/** Derives the MEI from the nonce PRK */
export declare function deriveMEI(noncePRK: BytesView): Promise<BytesView>;
//# sourceMappingURL=operations.d.ts.map