"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZWaveError_exports = {};
__export(ZWaveError_exports, {
  ZWaveError: () => ZWaveError,
  ZWaveErrorCodes: () => ZWaveErrorCodes,
  getErrorSuffix: () => getErrorSuffix,
  isMissingControllerACK: () => isMissingControllerACK,
  isMissingControllerCallback: () => isMissingControllerCallback,
  isMissingControllerResponse: () => isMissingControllerResponse,
  isRecoverableZWaveError: () => isRecoverableZWaveError,
  isTransmissionError: () => isTransmissionError,
  isZWaveError: () => isZWaveError,
  wasControllerReset: () => wasControllerReset
});
module.exports = __toCommonJS(ZWaveError_exports);
var ZWaveErrorCodes;
(function(ZWaveErrorCodes2) {
  ZWaveErrorCodes2[ZWaveErrorCodes2["PacketFormat_Truncated"] = 0] = "PacketFormat_Truncated";
  ZWaveErrorCodes2[ZWaveErrorCodes2["PacketFormat_Invalid"] = 1] = "PacketFormat_Invalid";
  ZWaveErrorCodes2[ZWaveErrorCodes2["PacketFormat_Checksum"] = 2] = "PacketFormat_Checksum";
  ZWaveErrorCodes2[ZWaveErrorCodes2["PacketFormat_InvalidPayload"] = 3] = "PacketFormat_InvalidPayload";
  ZWaveErrorCodes2[ZWaveErrorCodes2["PacketFormat_DecryptionFailed"] = 4] = "PacketFormat_DecryptionFailed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_Failed"] = 100] = "Driver_Failed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_Reset"] = 101] = "Driver_Reset";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_Destroyed"] = 102] = "Driver_Destroyed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_NotReady"] = 103] = "Driver_NotReady";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_InvalidDataReceived"] = 104] = "Driver_InvalidDataReceived";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_NotSupported"] = 105] = "Driver_NotSupported";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_NoPriority"] = 106] = "Driver_NoPriority";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_InvalidCache"] = 107] = "Driver_InvalidCache";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_InvalidOptions"] = 108] = "Driver_InvalidOptions";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_NoSecurity"] = 109] = "Driver_NoSecurity";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_FeatureDisabled"] = 110] = "Driver_FeatureDisabled";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_TaskRemoved"] = 111] = "Driver_TaskRemoved";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Driver_SerialPortClosed"] = 112] = "Driver_SerialPortClosed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_Timeout"] = 200] = "Controller_Timeout";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_NodeTimeout"] = 201] = "Controller_NodeTimeout";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_MessageDropped"] = 202] = "Controller_MessageDropped";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_ResponseNOK"] = 203] = "Controller_ResponseNOK";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_CallbackNOK"] = 204] = "Controller_CallbackNOK";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_Jammed"] = 205] = "Controller_Jammed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_Reset"] = 206] = "Controller_Reset";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_InclusionFailed"] = 207] = "Controller_InclusionFailed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_ExclusionFailed"] = 208] = "Controller_ExclusionFailed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_NotSupported"] = 209] = "Controller_NotSupported";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_InterviewRestarted"] = 210] = "Controller_InterviewRestarted";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_NodeNotFound"] = 211] = "Controller_NodeNotFound";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_EndpointNotFound"] = 212] = "Controller_EndpointNotFound";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_NodeRemoved"] = 213] = "Controller_NodeRemoved";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_NodeInsecureCommunication"] = 214] = "Controller_NodeInsecureCommunication";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_MessageExpired"] = 215] = "Controller_MessageExpired";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_CommandError"] = 216] = "Controller_CommandError";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_MessageTooLarge"] = 217] = "Controller_MessageTooLarge";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Controller_NotSupportedForLongRange"] = 218] = "Controller_NotSupportedForLongRange";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FWUpdateService_MissingInformation"] = 260] = "FWUpdateService_MissingInformation";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FWUpdateService_RequestError"] = 261] = "FWUpdateService_RequestError";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FWUpdateService_IntegrityCheckFailed"] = 262] = "FWUpdateService_IntegrityCheckFailed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FWUpdateService_DeviceMismatch"] = 263] = "FWUpdateService_DeviceMismatch";
  ZWaveErrorCodes2[ZWaveErrorCodes2["NVM_NotSupported"] = 280] = "NVM_NotSupported";
  ZWaveErrorCodes2[ZWaveErrorCodes2["NVM_InvalidJSON"] = 281] = "NVM_InvalidJSON";
  ZWaveErrorCodes2[ZWaveErrorCodes2["NVM_ObjectNotFound"] = 282] = "NVM_ObjectNotFound";
  ZWaveErrorCodes2[ZWaveErrorCodes2["NVM_InvalidFormat"] = 283] = "NVM_InvalidFormat";
  ZWaveErrorCodes2[ZWaveErrorCodes2["NVM_NoSpace"] = 284] = "NVM_NoSpace";
  ZWaveErrorCodes2[ZWaveErrorCodes2["NVM_NotOpen"] = 285] = "NVM_NotOpen";
  ZWaveErrorCodes2[ZWaveErrorCodes2["CC_Invalid"] = 300] = "CC_Invalid";
  ZWaveErrorCodes2[ZWaveErrorCodes2["CC_NoNodeID"] = 301] = "CC_NoNodeID";
  ZWaveErrorCodes2[ZWaveErrorCodes2["CC_NotSupported"] = 302] = "CC_NotSupported";
  ZWaveErrorCodes2[ZWaveErrorCodes2["CC_NotImplemented"] = 303] = "CC_NotImplemented";
  ZWaveErrorCodes2[ZWaveErrorCodes2["CC_NoAPI"] = 304] = "CC_NoAPI";
  ZWaveErrorCodes2[ZWaveErrorCodes2["CC_OperationFailed"] = 305] = "CC_OperationFailed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Deserialization_NotImplemented"] = 320] = "Deserialization_NotImplemented";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Arithmetic"] = 321] = "Arithmetic";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Argument_Invalid"] = 322] = "Argument_Invalid";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Config_Invalid"] = 340] = "Config_Invalid";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Config_NotFound"] = 341] = "Config_NotFound";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Config_CircularImport"] = 342] = "Config_CircularImport";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Config_Update_RegistryError"] = 343] = "Config_Update_RegistryError";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Config_Update_PackageManagerNotFound"] = 344] = "Config_Update_PackageManagerNotFound";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Config_Update_InstallFailed"] = 345] = "Config_Update_InstallFailed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["RemoveFailedNode_Failed"] = 360] = "RemoveFailedNode_Failed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["RemoveFailedNode_NodeOK"] = 361] = "RemoveFailedNode_NodeOK";
  ZWaveErrorCodes2[ZWaveErrorCodes2["ReplaceFailedNode_Failed"] = 362] = "ReplaceFailedNode_Failed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["ReplaceFailedNode_NodeOK"] = 363] = "ReplaceFailedNode_NodeOK";
  ZWaveErrorCodes2[ZWaveErrorCodes2["OTW_Update_Busy"] = 380] = "OTW_Update_Busy";
  ZWaveErrorCodes2[ZWaveErrorCodes2["HealthCheck_Busy"] = 400] = "HealthCheck_Busy";
  ZWaveErrorCodes2[ZWaveErrorCodes2["LinkReliabilityCheck_Busy"] = 401] = "LinkReliabilityCheck_Busy";
  ZWaveErrorCodes2[ZWaveErrorCodes2["ConfigurationCC_FirstParameterNumber"] = 1e3] = "ConfigurationCC_FirstParameterNumber";
  ZWaveErrorCodes2[ZWaveErrorCodes2["ConfigurationCC_NoLegacyScanOnNewDevices"] = 1001] = "ConfigurationCC_NoLegacyScanOnNewDevices";
  ZWaveErrorCodes2[ZWaveErrorCodes2["ConfigurationCC_NoResetToDefaultOnLegacyDevices"] = 1002] = "ConfigurationCC_NoResetToDefaultOnLegacyDevices";
  ZWaveErrorCodes2[ZWaveErrorCodes2["SupervisionCC_CommandFailed"] = 1100] = "SupervisionCC_CommandFailed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["ManufacturerProprietaryCC_NoManufacturerId"] = 1200] = "ManufacturerProprietaryCC_NoManufacturerId";
  ZWaveErrorCodes2[ZWaveErrorCodes2["AssociationCC_InvalidGroup"] = 1300] = "AssociationCC_InvalidGroup";
  ZWaveErrorCodes2[ZWaveErrorCodes2["AssociationCC_NotAllowed"] = 1301] = "AssociationCC_NotAllowed";
  ZWaveErrorCodes2[ZWaveErrorCodes2["SecurityCC_NoNonce"] = 1400] = "SecurityCC_NoNonce";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Security2CC_NoSPAN"] = 1401] = "Security2CC_NoSPAN";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Security2CC_NotInitialized"] = 1402] = "Security2CC_NotInitialized";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Security2CC_NotSecure"] = 1403] = "Security2CC_NotSecure";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Security2CC_MissingExtension"] = 1404] = "Security2CC_MissingExtension";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Security2CC_CannotDecode"] = 1405] = "Security2CC_CannotDecode";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Security2CC_InvalidQRCode"] = 1406] = "Security2CC_InvalidQRCode";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Security2CC_NoMPAN"] = 1407] = "Security2CC_NoMPAN";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Security2CC_CannotDecodeMulticast"] = 1408] = "Security2CC_CannotDecodeMulticast";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FirmwareUpdateCC_Busy"] = 1500] = "FirmwareUpdateCC_Busy";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FirmwareUpdateCC_NotUpgradable"] = 1501] = "FirmwareUpdateCC_NotUpgradable";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FirmwareUpdateCC_TargetNotFound"] = 1502] = "FirmwareUpdateCC_TargetNotFound";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FirmwareUpdateCC_FailedToStart"] = 1503] = "FirmwareUpdateCC_FailedToStart";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FirmwareUpdateCC_FailedToAbort"] = 1504] = "FirmwareUpdateCC_FailedToAbort";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FirmwareUpdateCC_Timeout"] = 1505] = "FirmwareUpdateCC_Timeout";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Invalid_Firmware_File"] = 1506] = "Invalid_Firmware_File";
  ZWaveErrorCodes2[ZWaveErrorCodes2["Unsupported_Firmware_Format"] = 1507] = "Unsupported_Firmware_Format";
  ZWaveErrorCodes2[ZWaveErrorCodes2["FirmwareUpdateCC_NetworkBusy"] = 1508] = "FirmwareUpdateCC_NetworkBusy";
  ZWaveErrorCodes2[ZWaveErrorCodes2["PowerlevelCC_UnsupportedTestNode"] = 1600] = "PowerlevelCC_UnsupportedTestNode";
})(ZWaveErrorCodes || (ZWaveErrorCodes = {}));
function getErrorSuffix(code) {
  return `ZW${code.toString().padStart(4, "0")}`;
}
__name(getErrorSuffix, "getErrorSuffix");
function appendErrorSuffix(message, code) {
  const suffix = ` (${getErrorSuffix(code)})`;
  if (!message.endsWith(suffix))
    message += suffix;
  return message;
}
__name(appendErrorSuffix, "appendErrorSuffix");
class ZWaveError extends Error {
  static {
    __name(this, "ZWaveError");
  }
  message;
  code;
  context;
  transactionSource;
  constructor(message, code, context, transactionSource) {
    super();
    this.message = message;
    this.code = code;
    this.context = context;
    this.transactionSource = transactionSource;
    this.message = appendErrorSuffix(message, code);
    Object.setPrototypeOf(this, ZWaveError.prototype);
    Object.getPrototypeOf(this).name = "ZWaveError";
    if (typeof transactionSource === "string") {
      this.stack = `ZWaveError: ${this.message}
${transactionSource}`;
    }
  }
}
function isZWaveError(e) {
  return e instanceof Error && Object.getPrototypeOf(e).name === "ZWaveError";
}
__name(isZWaveError, "isZWaveError");
function isTransmissionError(e) {
  return isZWaveError(e) && (e.code === ZWaveErrorCodes.Controller_Timeout || e.code === ZWaveErrorCodes.Controller_MessageDropped || e.code === ZWaveErrorCodes.Controller_CallbackNOK || e.code === ZWaveErrorCodes.Controller_ResponseNOK || e.code === ZWaveErrorCodes.Controller_NodeTimeout || e.code === ZWaveErrorCodes.Security2CC_CannotDecode);
}
__name(isTransmissionError, "isTransmissionError");
function isRecoverableZWaveError(e) {
  if (!isZWaveError(e))
    return false;
  switch (e.code) {
    case ZWaveErrorCodes.Controller_InterviewRestarted:
    case ZWaveErrorCodes.Controller_NodeRemoved:
      return true;
  }
  return false;
}
__name(isRecoverableZWaveError, "isRecoverableZWaveError");
function isMissingControllerACK(e) {
  return isZWaveError(e) && e.code === ZWaveErrorCodes.Controller_Timeout && e.context === "ACK";
}
__name(isMissingControllerACK, "isMissingControllerACK");
function wasControllerReset(e) {
  return isZWaveError(e) && e.code === ZWaveErrorCodes.Controller_Reset;
}
__name(wasControllerReset, "wasControllerReset");
function isMissingControllerResponse(e) {
  return isZWaveError(e) && e.code === ZWaveErrorCodes.Controller_Timeout && e.context === "response";
}
__name(isMissingControllerResponse, "isMissingControllerResponse");
function isMissingControllerCallback(e) {
  return isZWaveError(e) && e.code === ZWaveErrorCodes.Controller_Timeout && e.context === "callback";
}
__name(isMissingControllerCallback, "isMissingControllerCallback");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZWaveError,
  ZWaveErrorCodes,
  getErrorSuffix,
  isMissingControllerACK,
  isMissingControllerCallback,
  isMissingControllerResponse,
  isRecoverableZWaveError,
  isTransmissionError,
  isZWaveError,
  wasControllerReset
});
//# sourceMappingURL=ZWaveError.js.map
