"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Colorizer_exports = {};
__export(Colorizer_exports, {
  colorizer: () => colorizer
});
module.exports = __toCommonJS(Colorizer_exports);
var import_ansi_colors = __toESM(require("ansi-colors"), 1);
var import_triple_beam = require("triple-beam");
const defaultColors = import_triple_beam.configs.npm.colors;
const primaryAndInlineTagRegex = /\[([^\]]+)\]/g;
function getBgColorName(color) {
  return `bg${color[0].toUpperCase()}${color.slice(1)}`;
}
__name(getBgColorName, "getBgColorName");
function colorizeTextAndTags(textWithTags, textColor, bgColor) {
  return textColor(textWithTags.replaceAll(primaryAndInlineTagRegex, (match, group1) => bgColor("[") + import_ansi_colors.default.inverse(group1) + bgColor("]")));
}
__name(colorizeTextAndTags, "colorizeTextAndTags");
function colorizer(bg = true) {
  return {
    transform: /* @__PURE__ */ __name((info) => {
      const levelColorKey = defaultColors[info.level];
      const textColor = import_ansi_colors.default[levelColorKey];
      const bgColor = bg ? import_ansi_colors.default[getBgColorName(levelColorKey)] : ((txt) => txt);
      if (typeof info.message === "string") {
        info.message = colorizeTextAndTags(info.message, textColor, bgColor);
      } else {
        info.message = info.message.map((msg) => colorizeTextAndTags(msg, textColor, bgColor));
      }
      info.direction = import_ansi_colors.default.white(info.direction);
      if (info.label) {
        info.label = import_ansi_colors.default.gray.inverse(info.label);
      }
      if (info.timestamp) {
        info.timestamp = import_ansi_colors.default.gray(info.timestamp);
      }
      if (info.primaryTags) {
        info.primaryTags = colorizeTextAndTags(info.primaryTags, textColor, bgColor);
      }
      if (info.secondaryTags) {
        info.secondaryTags = import_ansi_colors.default.gray(info.secondaryTags);
      }
      return info;
    }, "transform")
  };
}
__name(colorizer, "colorizer");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  colorizer
});
//# sourceMappingURL=Colorizer.js.map
