"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Controller_exports = {};
__export(Controller_exports, {
  ControllerLogger: () => ControllerLogger
});
module.exports = __toCommonJS(Controller_exports);
var import_typeguards = require("alcalzone-shared/typeguards");
var import_CommandClasses = require("../definitions/CommandClasses.js");
var import_InterviewStage = require("../definitions/InterviewStage.js");
var import_Controller_definitions = require("./Controller.definitions.js");
var import_ZWaveLoggerBase = require("./ZWaveLoggerBase.js");
var import_shared = require("./shared.js");
class ControllerLogger extends import_ZWaveLoggerBase.ZWaveLoggerBase {
  static {
    __name(this, "ControllerLogger");
  }
  constructor(loggers) {
    super(loggers, import_Controller_definitions.CONTROLLER_LABEL);
  }
  isValueLogVisible() {
    return this.container.isLoglevelVisible(import_Controller_definitions.VALUE_LOGLEVEL);
  }
  isControllerLogVisible() {
    return this.container.isLoglevelVisible(import_Controller_definitions.CONTROLLER_LOGLEVEL);
  }
  /**
   * Logs a message
   * @param message The message to output
   */
  print(message, level) {
    const actualLevel = level || import_Controller_definitions.CONTROLLER_LOGLEVEL;
    if (!this.container.isLoglevelVisible(actualLevel))
      return;
    this.logger.log({
      level: actualLevel,
      message,
      direction: (0, import_shared.getDirectionPrefix)("none"),
      context: { source: "controller", type: "controller" }
    });
  }
  logNode(nodeId, messageOrOptions, logLevel) {
    if (typeof messageOrOptions === "string") {
      return this.logNode(nodeId, {
        message: messageOrOptions,
        level: logLevel
      });
    }
    const { level, message, direction, endpoint } = messageOrOptions;
    const actualLevel = level || import_Controller_definitions.CONTROLLER_LOGLEVEL;
    if (!this.container.isLoglevelVisible(actualLevel))
      return;
    if (!this.container.isNodeLoggingVisible(nodeId))
      return;
    const context = {
      nodeId,
      source: "controller",
      type: "node",
      direction: direction || "none"
    };
    if (endpoint)
      context.endpoint = endpoint;
    this.logger.log({
      level: actualLevel,
      primaryTags: (0, import_shared.tagify)([(0, import_shared.getNodeTag)(nodeId)]),
      message,
      secondaryTags: endpoint ? (0, import_shared.tagify)([`Endpoint ${endpoint}`]) : void 0,
      direction: (0, import_shared.getDirectionPrefix)(direction || "none"),
      context
    });
  }
  valueEventPrefixes = Object.freeze({
    added: "+",
    updated: "~",
    removed: "-",
    notification: "!"
  });
  formatValue(value) {
    if ((0, import_typeguards.isObject)(value))
      return JSON.stringify(value);
    if (typeof value !== "string")
      return String(value);
    return `"${value}"`;
  }
  value(change, args) {
    if (!this.isValueLogVisible())
      return;
    if (!this.container.isNodeLoggingVisible(args.nodeId))
      return;
    const context = {
      nodeId: args.nodeId,
      change,
      commandClass: args.commandClass,
      internal: args.internal,
      property: args.property,
      source: "controller",
      type: "value"
    };
    const primaryTags = [
      (0, import_shared.getNodeTag)(args.nodeId),
      this.valueEventPrefixes[change],
      import_CommandClasses.CommandClasses[args.commandClass]
    ];
    const secondaryTags = [];
    if (args.endpoint != void 0) {
      context.endpoint = args.endpoint;
      secondaryTags.push(`Endpoint ${args.endpoint}`);
    }
    if (args.internal === true) {
      secondaryTags.push("internal");
    }
    let message = args.property.toString();
    if (args.propertyKey != void 0) {
      context.propertyKey = args.propertyKey;
      message += `[${args.propertyKey}]`;
    }
    switch (change) {
      case "added":
        message += `: ${this.formatValue(args.newValue)}`;
        break;
      case "updated": {
        const _args = args;
        message += `: ${this.formatValue(_args.prevValue)} => ${this.formatValue(_args.newValue)}`;
        break;
      }
      case "removed":
        message += ` (was ${this.formatValue(args.prevValue)})`;
        break;
      case "notification":
        message += `: ${this.formatValue(args.value)}`;
        break;
    }
    this.logger.log({
      level: import_Controller_definitions.VALUE_LOGLEVEL,
      primaryTags: (0, import_shared.tagify)(primaryTags),
      secondaryTags: (0, import_shared.tagify)(secondaryTags),
      message,
      direction: (0, import_shared.getDirectionPrefix)("none"),
      context
    });
  }
  /** Prints a log message for updated metadata of a value id */
  metadataUpdated(args) {
    if (!this.isValueLogVisible())
      return;
    if (!this.container.isNodeLoggingVisible(args.nodeId))
      return;
    const context = {
      nodeId: args.nodeId,
      commandClass: args.commandClass,
      internal: args.internal,
      property: args.property,
      source: "controller",
      type: "value"
    };
    const primaryTags = [
      (0, import_shared.getNodeTag)(args.nodeId),
      import_CommandClasses.CommandClasses[args.commandClass]
    ];
    const secondaryTags = [];
    if (args.endpoint != void 0) {
      context.endpoint = args.endpoint;
      secondaryTags.push(`Endpoint ${args.endpoint}`);
    }
    if (args.internal === true) {
      secondaryTags.push("internal");
    }
    let message = args.property.toString();
    if (args.propertyKey != void 0) {
      context.propertyKey = args.propertyKey;
      message += `[${args.propertyKey}]`;
    }
    message += ": metadata updated";
    this.logger.log({
      level: import_Controller_definitions.VALUE_LOGLEVEL,
      primaryTags: (0, import_shared.tagify)(primaryTags),
      secondaryTags: (0, import_shared.tagify)(secondaryTags),
      message,
      direction: (0, import_shared.getDirectionPrefix)("none"),
      context
    });
  }
  /** Logs the interview progress of a node */
  interviewStage(node) {
    if (!this.isControllerLogVisible())
      return;
    if (!this.container.isNodeLoggingVisible(node.id))
      return;
    this.logger.log({
      level: import_Controller_definitions.CONTROLLER_LOGLEVEL,
      primaryTags: (0, import_shared.tagify)([(0, import_shared.getNodeTag)(node.id)]),
      message: node.interviewStage === import_InterviewStage.InterviewStage.Complete ? "Interview completed" : `Interview stage completed: ${import_InterviewStage.InterviewStage[node.interviewStage]}`,
      direction: (0, import_shared.getDirectionPrefix)("none"),
      context: {
        nodeId: node.id,
        source: "controller",
        type: "node",
        direction: "none"
      }
    });
  }
  /** Logs the interview progress of a node */
  interviewStart(node) {
    if (!this.isControllerLogVisible())
      return;
    if (!this.container.isNodeLoggingVisible(node.id))
      return;
    const message = `Beginning interview - last completed stage: ${import_InterviewStage.InterviewStage[node.interviewStage]}`;
    this.logger.log({
      level: import_Controller_definitions.CONTROLLER_LOGLEVEL,
      primaryTags: (0, import_shared.tagify)([(0, import_shared.getNodeTag)(node.id)]),
      message,
      direction: (0, import_shared.getDirectionPrefix)("none"),
      context: {
        nodeId: node.id,
        source: "controller",
        type: "node",
        direction: "none"
      }
    });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ControllerLogger
});
//# sourceMappingURL=Controller.js.map
