"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var format_exports = {};
__export(format_exports, {
  combine: () => combine,
  formatLogMessage: () => formatLogMessage,
  label: () => label,
  printLogMessage: () => printLogMessage,
  timestamp: () => timestamp
});
module.exports = __toCommonJS(format_exports);
var import_triple_beam = require("triple-beam");
var import_date = require("../util/date.js");
var import_shared = require("./shared.js");
function combine(...formats) {
  return {
    transform: /* @__PURE__ */ __name((info) => {
      for (const format of formats) {
        info = format.transform(info);
      }
      return info;
    }, "transform")
  };
}
__name(combine, "combine");
function label(label2) {
  return {
    transform: /* @__PURE__ */ __name((info) => {
      info.label = label2;
      return info;
    }, "transform")
  };
}
__name(label, "label");
function timestamp(format) {
  return {
    transform: /* @__PURE__ */ __name((info) => {
      if (format) {
        info.timestamp = (0, import_date.formatDate)(/* @__PURE__ */ new Date(), format);
      } else {
        info.timestamp = (/* @__PURE__ */ new Date()).toISOString();
      }
      return info;
    }, "transform")
  };
}
__name(timestamp, "timestamp");
const formatLogMessage = {
  transform: /* @__PURE__ */ __name((info) => {
    const messageLines = (0, import_shared.messageToLines)(info.message);
    const firstMessageLineLength = messageLines[0].length;
    info.multiline = messageLines.length > 1 || !(0, import_shared.messageFitsIntoOneLine)(info, info.message.length);
    if (info.secondaryTags) {
      info.secondaryTagPadding = Math.max(
        // -1 has the special meaning that we don't print any padding,
        // because the message takes all the available space
        -1,
        import_shared.LOG_WIDTH - 1 - (0, import_shared.calculateFirstLineLength)(info, firstMessageLineLength)
      );
    }
    if (info.multiline) {
      const lines = [];
      let isFirstLine = true;
      for (let message of messageLines) {
        while (message.length) {
          const cut = Math.min(message.length, isFirstLine ? import_shared.LOG_WIDTH - (0, import_shared.calculateFirstLineLength)(info, 0) - 1 : import_shared.LOG_WIDTH - import_shared.CONTROL_CHAR_WIDTH);
          isFirstLine = false;
          lines.push(message.slice(0, cut));
          message = message.slice(cut);
        }
      }
      info.message = lines.join("\n");
    }
    return info;
  }, "transform")
};
function printLogMessage(shortTimestamps) {
  return {
    transform: /* @__PURE__ */ __name((info) => {
      const messageLines = (0, import_shared.messageToLines)(info.message);
      if (info.secondaryTagPadding == void 0) {
        info.secondaryTagPadding = -1;
      }
      let firstLine = [
        info.primaryTags,
        messageLines[0],
        info.secondaryTagPadding < 0 ? void 0 : " ".repeat(info.secondaryTagPadding),
        // If the secondary tag padding is zero, the previous segment gets
        // filtered out and we have one less space than necessary
        info.secondaryTagPadding === 0 && info.secondaryTags ? " " + info.secondaryTags : info.secondaryTags
      ].filter((item) => !!item).join(" ");
      firstLine = `${info.timestamp} ${info.label} ${info.direction}${firstLine}`;
      const lines = [firstLine];
      if (info.multiline) {
        lines.push(...messageLines.slice(1).map((line) => (
          // Skip the columns for the timestamp and the channel name
          (shortTimestamps ? import_shared.timestampPaddingShort : import_shared.timestampPadding) + import_shared.channelPadding + import_shared.directionPrefixPadding + line
        )));
      }
      info[import_triple_beam.MESSAGE] = lines.join("\n");
      return info;
    }, "transform")
  };
}
__name(printLogMessage, "printLogMessage");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  combine,
  formatLogMessage,
  label,
  printLogMessage,
  timestamp
});
//# sourceMappingURL=format.js.map
