"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var utils_exports = {};
__export(utils_exports, {
  fail: () => fail,
  parseTLV: () => parseTLV,
  parseTLVData: () => parseTLVData,
  readLevel: () => readLevel,
  readUInt16: () => readUInt16,
  readUInt8: () => readUInt8
});
module.exports = __toCommonJS(utils_exports);
var import_shared = require("@zwave-js/shared");
var import_Protocol = require("../definitions/Protocol.js");
var import_ZWaveError = require("../error/ZWaveError.js");
var import_Primitive = require("../values/Primitive.js");
var import_definitions = require("./definitions.js");
function readNumber(qr, offset, length) {
  return parseInt(qr.slice(offset, offset + length), 10);
}
__name(readNumber, "readNumber");
function fail(reason) {
  throw new import_ZWaveError.ZWaveError(`Invalid QR code: ${reason}`, import_ZWaveError.ZWaveErrorCodes.Security2CC_InvalidQRCode);
}
__name(fail, "fail");
function readLevel(qr, offset) {
  const ret = readNumber(qr, offset, 2);
  if (ret > 99)
    fail("invalid data");
  return ret;
}
__name(readLevel, "readLevel");
function readUInt8(qr, offset) {
  const ret = readNumber(qr, offset, 3);
  if (ret > 255)
    fail("invalid data");
  return ret;
}
__name(readUInt8, "readUInt8");
function readUInt16(qr, offset) {
  const ret = readNumber(qr, offset, 5);
  if (ret > 65535)
    fail("invalid data");
  return ret;
}
__name(readUInt16, "readUInt16");
function parseTLVData(type, data) {
  switch (type) {
    case import_definitions.ProvisioningInformationType.ProductType: {
      const deviceClasses = readUInt16(data, 0);
      const installerIconType = readUInt16(data, 5);
      const ret = {
        genericDeviceClass: deviceClasses >>> 8,
        specificDeviceClass: deviceClasses & 255,
        installerIconType
      };
      return ret;
    }
    case import_definitions.ProvisioningInformationType.ProductId: {
      const manufacturerId = readUInt16(data, 0);
      const productType = readUInt16(data, 5);
      const productId = readUInt16(data, 10);
      const applicationVersionNumeric = readUInt16(data, 15);
      const applicationVersion = `${applicationVersionNumeric >>> 8}.${applicationVersionNumeric & 255}`;
      const ret = {
        manufacturerId,
        productType,
        productId,
        applicationVersion
      };
      return ret;
    }
    case import_definitions.ProvisioningInformationType.MaxInclusionRequestInterval: {
      const maxInclusionRequestInterval = 128 * readLevel(data, 0);
      const ret = {
        maxInclusionRequestInterval
      };
      return ret;
    }
    case import_definitions.ProvisioningInformationType.UUID16: {
      const buffer = new import_shared.Bytes(16);
      const presentationFormat = readLevel(data, 0);
      if (presentationFormat !== 0)
        return;
      for (let chunk = 0; chunk < 8; chunk++) {
        const value = readUInt16(data, 2 + chunk * 5);
        buffer.writeUInt16BE(value, chunk * 2);
      }
      const ret = {
        uuid: buffer.toString("hex")
      };
      return ret;
    }
    case import_definitions.ProvisioningInformationType.SupportedProtocols: {
      const bitMask = Uint8Array.from([
        data.length === 2 ? readLevel(data, 0) : data.length === 3 ? readUInt8(data, 0) : data.length === 5 ? readUInt16(data, 0) : 0
      ]);
      const supportedProtocols = (0, import_Primitive.parseBitMask)(bitMask, import_Protocol.Protocols.ZWave);
      const ret = {
        supportedProtocols
      };
      return ret;
    }
  }
}
__name(parseTLVData, "parseTLVData");
function parseTLV(qr) {
  let offset = 0;
  if (qr.length - offset < 4)
    fail("incomplete TLV block");
  const typeCritical = readLevel(qr, offset);
  const type = typeCritical >>> 1;
  const critical = !!(typeCritical & 1);
  const length = readLevel(qr, offset + 2);
  offset += 4;
  if (qr.length - offset < length)
    fail("incomplete TLV block");
  const data = qr.slice(offset, offset + length);
  offset += length;
  const parsed = parseTLVData(type, data);
  if (!parsed && critical)
    fail("Unsupported critical TLV block");
  let entry;
  if (parsed) {
    entry = {
      type,
      ...parsed
    };
  } else {
    entry = {
      type,
      [import_definitions.ProvisioningInformationType[type]]: data
    };
  }
  return {
    entry,
    charsRead: offset
  };
}
__name(parseTLV, "parseTLV");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  fail,
  parseTLV,
  parseTLVData,
  readLevel,
  readUInt16,
  readUInt8
});
//# sourceMappingURL=utils.js.map
