"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Meters_exports = {};
__export(Meters_exports, {
  getAllMeterScales: () => getAllMeterScales,
  getAllMeters: () => getAllMeters,
  getMeter: () => getMeter,
  getMeterName: () => getMeterName,
  getMeterScale: () => getMeterScale,
  getUnknownMeterScale: () => getUnknownMeterScale,
  meters: () => meters
});
module.exports = __toCommonJS(Meters_exports);
var import_shared = require("@zwave-js/shared");
const meters = Object.freeze({
  [1]: {
    name: "Electric",
    scales: {
      [0]: {
        label: "kWh",
        unit: "kWh"
      },
      [1]: {
        label: "kVAh",
        unit: "kVAh"
      },
      [2]: {
        label: "W",
        unit: "W"
      },
      [3]: {
        label: "Pulse count"
      },
      [4]: {
        label: "V",
        unit: "V"
      },
      [5]: {
        label: "A",
        unit: "A"
      },
      [6]: {
        label: "Power Factor"
      },
      [7]: {
        label: "kVar",
        unit: "kVar"
      },
      [8]: {
        label: "kVarh",
        unit: "kVarh"
      }
    }
  },
  [2]: {
    name: "Gas",
    scales: {
      [0]: {
        label: "Cubic meters",
        unit: "m\xB3"
      },
      [1]: {
        label: "Cubic feet",
        unit: "ft\xB3"
      },
      [3]: {
        label: "Pulse count"
      }
    }
  },
  [3]: {
    name: "Water",
    scales: {
      [0]: {
        label: "Cubic meters",
        unit: "m\xB3"
      },
      [1]: {
        label: "Cubic feet",
        unit: "ft\xB3"
      },
      [2]: {
        label: "US gallons",
        unit: "gal"
      },
      [3]: {
        label: "Pulse count"
      }
    }
  },
  [4]: {
    name: "Heating",
    scales: {
      [0]: {
        label: "kWh",
        unit: "kWh"
      }
    }
  },
  [5]: {
    name: "Cooling",
    scales: {
      [0]: {
        label: "kWh",
        unit: "kWh"
      }
    }
  }
});
function getMeter(type) {
  const meter = meters[type];
  if (!meter)
    return;
  return {
    key: type,
    ...meter
  };
}
__name(getMeter, "getMeter");
function getAllMeters() {
  return Object.entries(meters).map(([key, value]) => ({ key: parseInt(key, 10), ...value }));
}
__name(getAllMeters, "getAllMeters");
function getMeterName(meterType) {
  return getMeter(meterType)?.name ?? `UNKNOWN (${(0, import_shared.num2hex)(meterType)})`;
}
__name(getMeterName, "getMeterName");
function getMeterScale(type, scale) {
  const meter = getMeter(type);
  if (!meter)
    return;
  const scaleDef = meter?.scales?.[scale];
  if (!scaleDef)
    return;
  return {
    key: scale,
    ...scaleDef
  };
}
__name(getMeterScale, "getMeterScale");
function getUnknownMeterScale(key) {
  return {
    key,
    label: `Unknown (${(0, import_shared.num2hex)(key)})`
  };
}
__name(getUnknownMeterScale, "getUnknownMeterScale");
function getAllMeterScales(meterType) {
  const meter = getMeter(meterType);
  if (!meter)
    return;
  return Object.entries(meter.scales).map(([key, value]) => ({ key: parseInt(key, 10), ...value }));
}
__name(getAllMeterScales, "getAllMeterScales");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getAllMeterScales,
  getAllMeters,
  getMeter,
  getMeterName,
  getMeterScale,
  getUnknownMeterScale,
  meters
});
//# sourceMappingURL=Meters.js.map
