"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Scales_exports = {};
__export(Scales_exports, {
  getAllNamedScaleGroups: () => getAllNamedScaleGroups,
  getNamedScale: () => getNamedScale,
  getNamedScaleGroup: () => getNamedScaleGroup,
  getUnknownScale: () => getUnknownScale
});
module.exports = __toCommonJS(Scales_exports);
var import_shared = require("@zwave-js/shared");
var import_ZWaveError = require("../error/ZWaveError.js");
const namedScales = Object.freeze({
  temperature: {
    [0]: {
      label: "Celsius",
      unit: "\xB0C"
    },
    [1]: {
      label: "Fahrenheit",
      unit: "\xB0F"
    }
  },
  humidity: {
    [0]: {
      label: "Percentage value",
      unit: "%"
    },
    [1]: {
      label: "Absolute humidity",
      unit: "g/m\xB3"
    }
  },
  mass: {
    [0]: {
      label: "Kilogram",
      unit: "kg"
    }
  },
  acceleration: {
    [0]: {
      label: "Meter per square second",
      unit: "m/s\xB2"
    }
  },
  percentage: {
    [0]: {
      label: "Percentage value",
      unit: "%"
    }
  },
  acidity: {
    [0]: {
      label: "Acidity",
      unit: "pH"
    }
  },
  direction: {
    [0]: {
      label: "Degrees",
      unit: "\xB0",
      description: "0\xB0 = no motion detected, 90\xB0 = east, 180\xB0 = south, 270\xB0 = west, 360\xB0 = north"
    }
  },
  pressure: {
    [0]: {
      label: "Kilopascal",
      unit: "kPa"
    },
    [1]: {
      label: "Pound per square inch",
      unit: "psi"
    }
  },
  airPressure: {
    [0]: {
      label: "Kilopascal",
      unit: "kPa"
    },
    [1]: {
      label: "Inches of Mercury",
      unit: "inHg"
    }
  },
  density: {
    [0]: {
      label: "Density",
      unit: "\xB5g/m\xB3"
    }
  },
  unitless: {
    [0]: {
      label: "Unitless"
    }
  }
});
function getNamedScaleGroup(group) {
  const scaleGroup = namedScales[group];
  if (!scaleGroup) {
    throw new import_ZWaveError.ZWaveError(`The scale group with name ${group} does not exist`, import_ZWaveError.ZWaveErrorCodes.Argument_Invalid);
  }
  return scaleGroup;
}
__name(getNamedScaleGroup, "getNamedScaleGroup");
function getAllNamedScaleGroups() {
  return Object.entries(namedScales).map(([name, scales]) => ({ name, scales }));
}
__name(getAllNamedScaleGroups, "getAllNamedScaleGroups");
function getNamedScale(group, key) {
  const scaleGroup = getNamedScaleGroup(group);
  const scaleDef = scaleGroup[key];
  if (!scaleDef) {
    throw new import_ZWaveError.ZWaveError(`The scale group ${group} does not contain a scale with key ${key}`, import_ZWaveError.ZWaveErrorCodes.Argument_Invalid);
  }
  return {
    key,
    ...scaleDef
  };
}
__name(getNamedScale, "getNamedScale");
function getUnknownScale(key) {
  return {
    key,
    label: `Unknown (${(0, import_shared.num2hex)(key)})`
  };
}
__name(getUnknownScale, "getUnknownScale");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getAllNamedScaleGroups,
  getNamedScale,
  getNamedScaleGroup,
  getUnknownScale
});
//# sourceMappingURL=Scales.js.map
