"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ctr_drbg_exports = {};
__export(ctr_drbg_exports, {
  CtrDRBG: () => CtrDRBG
});
module.exports = __toCommonJS(ctr_drbg_exports);
var import_crypto = require("../crypto/index.js");
var import_shared = require("../crypto/shared.js");
const KEY_LEN = 16;
const BLOCK_LEN = 16;
const SEED_LEN = KEY_LEN + BLOCK_LEN;
class CtrDRBG {
  static {
    __name(this, "CtrDRBG");
  }
  key = new Uint8Array(KEY_LEN);
  v = new Uint8Array(BLOCK_LEN);
  // Reseed counter is not used
  saveState() {
    return { key: Uint8Array.from(this.key), v: Uint8Array.from(this.v) };
  }
  restoreState(state) {
    this.key = state.key;
    this.v = state.v;
  }
  async init(entropy, personalizationString) {
    if (entropy.length !== SEED_LEN) {
      throw new Error(`entropy must be ${SEED_LEN} bytes long`);
    }
    if (personalizationString) {
      if (personalizationString.length > SEED_LEN) {
        throw new Error("Personalization string is too long.");
      }
      for (let i = 0; i < personalizationString.length; i++) {
        entropy[i] ^= personalizationString[i];
      }
    }
    await this.update(entropy);
  }
  async update(providedData) {
    if (providedData && providedData.length !== SEED_LEN) {
      throw new Error(`providedData must be ${SEED_LEN} bytes long`);
    }
    let temp = new Uint8Array(SEED_LEN);
    let tempOffset = 0;
    while (tempOffset < SEED_LEN) {
      (0, import_shared.increment)(this.v);
      const encrypted = await (0, import_crypto.encryptAES128ECB)(this.v, this.key);
      temp.set(encrypted, tempOffset);
      tempOffset += BLOCK_LEN;
    }
    if (providedData) {
      temp = (0, import_shared.xor)(temp, providedData);
    }
    this.key = temp.subarray(0, KEY_LEN);
    this.v = temp.subarray(KEY_LEN);
  }
  async generate(len) {
    const temp = new Uint8Array(Math.ceil(len / BLOCK_LEN) * BLOCK_LEN);
    let tempOffset = 0;
    while (tempOffset < len) {
      (0, import_shared.increment)(this.v);
      const encrypted = await (0, import_crypto.encryptAES128ECB)(this.v, this.key);
      temp.set(encrypted, tempOffset);
      tempOffset += BLOCK_LEN;
    }
    await this.update(void 0);
    return temp.subarray(0, len);
  }
  async reseed(entropy) {
    await this.update(entropy);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CtrDRBG
});
//# sourceMappingURL=ctr_drbg.js.map
