"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var date_exports = {};
__export(date_exports, {
  formatDate: () => formatDate,
  getDSTInfo: () => getDSTInfo,
  getDefaultDSTInfo: () => getDefaultDSTInfo,
  highResTimestamp: () => highResTimestamp,
  timespan: () => timespan
});
module.exports = __toCommonJS(date_exports);
var import_dayjs = __toESM(require("dayjs"), 1);
function getDefaultDSTInfo(defaultOffset) {
  const thisYear = (/* @__PURE__ */ new Date()).getUTCFullYear();
  if (defaultOffset == void 0) {
    defaultOffset = -(/* @__PURE__ */ new Date()).getTimezoneOffset();
  }
  return {
    startDate: new Date(Date.UTC(thisYear, 2, 31, 1)),
    endDate: new Date(Date.UTC(thisYear, 9, 31, 1)),
    standardOffset: defaultOffset,
    dstOffset: defaultOffset
  };
}
__name(getDefaultDSTInfo, "getDefaultDSTInfo");
function findSwitchDate(date1, date2, offset) {
  const stepSize = 6e4;
  function middleDate(date12, date22) {
    const middleTime = Math.floor((date12.getTime() + date22.getTime()) / 2 / stepSize) * stepSize;
    return new Date(middleTime);
  }
  __name(middleDate, "middleDate");
  while (date1 < date2) {
    const mid = middleDate(date1, date2);
    if (mid.getTimezoneOffset() === offset) {
      date2 = mid;
    } else {
      date1 = new Date(mid.getTime() + stepSize);
    }
  }
  if (date1.getTimezoneOffset() !== offset)
    return void 0;
  return date1;
}
__name(findSwitchDate, "findSwitchDate");
function getDSTInfo(now = /* @__PURE__ */ new Date()) {
  const halfAYearAgo = (0, import_dayjs.default)(now).subtract(6, "months").toDate();
  const inAHalfYear = (0, import_dayjs.default)(now).add(6, "months").toDate();
  if (now.getTimezoneOffset() === halfAYearAgo.getTimezoneOffset() || now.getTimezoneOffset() === inAHalfYear.getTimezoneOffset()) {
    return getDefaultDSTInfo();
  }
  const offsets = [
    -now.getTimezoneOffset(),
    -inAHalfYear.getTimezoneOffset()
  ];
  const dates = [
    findSwitchDate(halfAYearAgo, now, -offsets[0]),
    findSwitchDate(now, inAHalfYear, -offsets[1])
  ];
  if (dates[0] == void 0 || dates[1] == void 0) {
    return getDefaultDSTInfo();
  }
  if (offsets[0] > offsets[1]) {
    return {
      startDate: dates[0],
      endDate: dates[1],
      dstOffset: offsets[0],
      standardOffset: offsets[1]
    };
  } else {
    return {
      // We don't have DST now, this is the next start date
      startDate: dates[1],
      endDate: dates[0],
      dstOffset: offsets[1],
      standardOffset: offsets[0]
    };
  }
}
__name(getDSTInfo, "getDSTInfo");
function highResTimestamp() {
  if (typeof process !== "undefined") {
    const [s, ns] = process.hrtime();
    return s * 1e9 + ns;
  } else if (performance != void 0) {
    return performance.now() * 1e6;
  } else {
    throw new Error("No high-resolution timer available");
  }
}
__name(highResTimestamp, "highResTimestamp");
const timespan = Object.freeze({
  seconds: /* @__PURE__ */ __name((num) => Math.round(num * 1e3), "seconds"),
  minutes: /* @__PURE__ */ __name((num) => timespan.seconds(num * 60), "minutes"),
  hours: /* @__PURE__ */ __name((num) => timespan.minutes(num * 60), "hours"),
  days: /* @__PURE__ */ __name((num) => timespan.hours(num * 24), "days")
});
function formatDate(date, format) {
  return (0, import_dayjs.default)(date).format(format);
}
__name(formatDate, "formatDate");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  formatDate,
  getDSTInfo,
  getDefaultDSTInfo,
  highResTimestamp,
  timespan
});
//# sourceMappingURL=date.js.map
