"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Timeout_exports = {};
__export(Timeout_exports, {
  Timeout: () => Timeout
});
module.exports = __toCommonJS(Timeout_exports);
var import_math = require("alcalzone-shared/math");
class Timeout {
  static {
    __name(this, "Timeout");
  }
  unit;
  constructor(value, unit) {
    this.unit = unit;
    if (value === 0)
      this.unit = "none";
    switch (unit) {
      case "none":
      case "infinite":
        value = 0;
        break;
    }
    this.value = value;
  }
  _value;
  get value() {
    return this._value;
  }
  set value(v) {
    this._value = (0, import_math.clamp)(v, 0, this.unit === "seconds" ? 60 : 191);
  }
  static isTimeout(value) {
    return typeof value === "object" && value != null && "value" in value && typeof value.value === "number" && "unit" in value && typeof value.unit === "string";
  }
  static parse(payload) {
    if (payload == void 0)
      return void 0;
    if (payload === 255)
      return new Timeout(0, "infinite");
    const isMinutes = !!(payload & 64);
    const value = (payload & 63) + (isMinutes ? 1 : 0);
    return new Timeout(value, isMinutes ? "minutes" : "seconds");
  }
  /** Serializes a timeout for a Set command */
  serialize() {
    if (this.unit === "infinite")
      return 255;
    if (this.unit === "none")
      return 0;
    const isMinutes = this.unit === "minutes";
    return (isMinutes ? 64 : 0) | this._value & 63;
  }
  toJSON() {
    if (this.unit === "none" || this.unit === "infinite")
      return this.unit;
    return {
      value: this.value,
      unit: this.unit
    };
  }
  toMilliseconds() {
    switch (this.unit) {
      case "none":
        return 0;
      case "minutes":
        return this._value * 6e4;
      case "seconds":
        return this._value * 1e3;
      case "infinite":
        return Number.POSITIVE_INFINITY;
    }
  }
  toString() {
    switch (this.unit) {
      case "minutes":
        return `[Timeout: ${this._value}${this.value === 1 ? "minute" : "minutes"}]`;
      case "seconds":
        return `[Timeout: ${this._value}${this.value === 1 ? "second" : "seconds"}]`;
      default:
        return `[Timeout: ${this.unit}]`;
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Timeout
});
//# sourceMappingURL=Timeout.js.map
