"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JSONTransport = void 0;
const stream_1 = require("stream");
const triple_beam_1 = require("triple-beam");
const winston_transport_1 = __importDefault(require("winston-transport"));
class JSONTransport extends winston_transport_1.default {
    constructor() {
        super({ level: "silly" });
        this._stream = new stream_1.PassThrough({
            objectMode: true,
        });
    }
    log(info, next) {
        const { 
        // remove these properties from the result object
        multiline, secondaryTagPadding, [triple_beam_1.LEVEL]: _, 
        // keep the formatted message if it exists
        [triple_beam_1.MESSAGE]: formattedMessage, 
        // And keep the rest
        ...logObject } = info;
        if (!!formattedMessage) {
            logObject.message = formattedMessage;
        }
        this._stream.write(logObject);
        next();
    }
    get stream() {
        return this._stream;
    }
    close() {
        var _a;
        (_a = this._stream) === null || _a === void 0 ? void 0 : _a.end();
    }
}
exports.JSONTransport = JSONTransport;
//# sourceMappingURL=index.js.map