"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var routeCache_exports = {};
__export(routeCache_exports, {
  EMPTY_ROUTECACHE_FILL: () => EMPTY_ROUTECACHE_FILL,
  ROUTECACHE_SIZE: () => ROUTECACHE_SIZE,
  emptyRouteCache: () => emptyRouteCache,
  encodeRoute: () => encodeRoute,
  getEmptyRoute: () => getEmptyRoute,
  parseRoute: () => parseRoute
});
module.exports = __toCommonJS(routeCache_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
const ROUTE_SIZE = import_core.MAX_REPEATERS + 1;
const ROUTECACHE_SIZE = 2 * ROUTE_SIZE;
const EMPTY_ROUTECACHE_FILL = 255;
const emptyRouteCache = new Uint8Array(ROUTECACHE_SIZE).fill(EMPTY_ROUTECACHE_FILL);
var Beaming;
(function(Beaming2) {
  Beaming2[Beaming2["1000ms"] = 64] = "1000ms";
  Beaming2[Beaming2["250ms"] = 32] = "250ms";
})(Beaming || (Beaming = {}));
function parseRoute(buffer, offset) {
  const routeConf = buffer[offset + import_core.MAX_REPEATERS];
  const ret = {
    beaming: Beaming[routeConf & 96] ?? false,
    protocolRate: routeConf & import_core.protocolDataRateMask,
    repeaterNodeIDs: [
      ...buffer.subarray(offset, offset + import_core.MAX_REPEATERS)
    ].filter((id) => id !== 0)
  };
  if (ret.repeaterNodeIDs[0] === 254)
    delete ret.repeaterNodeIDs;
  return ret;
}
__name(parseRoute, "parseRoute");
function encodeRoute(route) {
  const ret = new import_shared.Bytes(ROUTE_SIZE).fill(0);
  if (route) {
    if (route.repeaterNodeIDs) {
      for (let i = 0; i < import_core.MAX_REPEATERS && i < route.repeaterNodeIDs.length; i++) {
        ret[i] = route.repeaterNodeIDs[i];
      }
    } else {
      ret[0] = 254;
    }
    let routeConf = 0;
    if (route.beaming)
      routeConf |= Beaming[route.beaming] ?? 0;
    routeConf |= route.protocolRate & import_core.protocolDataRateMask;
    ret[ROUTE_SIZE - 1] = routeConf;
  }
  return ret;
}
__name(encodeRoute, "encodeRoute");
function getEmptyRoute() {
  return {
    beaming: false,
    protocolRate: import_core.RouteProtocolDataRate.ZWave_40k,
    repeaterNodeIDs: void 0
  };
}
__name(getEmptyRoute, "getEmptyRoute");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EMPTY_ROUTECACHE_FILL,
  ROUTECACHE_SIZE,
  emptyRouteCache,
  encodeRoute,
  getEmptyRoute,
  parseRoute
});
//# sourceMappingURL=routeCache.js.map
