"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var utils_exports = {};
__export(utils_exports, {
  nvmReadBuffer: () => nvmReadBuffer,
  nvmReadUInt16BE: () => nvmReadUInt16BE,
  nvmReadUInt16LE: () => nvmReadUInt16LE,
  nvmReadUInt32BE: () => nvmReadUInt32BE,
  nvmReadUInt32LE: () => nvmReadUInt32LE,
  nvmReadUInt8: () => nvmReadUInt8,
  nvmWriteBuffer: () => nvmWriteBuffer
});
module.exports = __toCommonJS(utils_exports);
var import_shared = require("@zwave-js/shared");
async function nvmReadUInt32LE(io, position) {
  const { buffer } = await io.read(position, 4);
  const bytes = import_shared.Bytes.view(buffer);
  return bytes.readUInt32LE(0);
}
__name(nvmReadUInt32LE, "nvmReadUInt32LE");
async function nvmReadUInt16LE(io, position) {
  const { buffer } = await io.read(position, 2);
  const bytes = import_shared.Bytes.view(buffer);
  return bytes.readUInt16LE(0);
}
__name(nvmReadUInt16LE, "nvmReadUInt16LE");
async function nvmReadUInt32BE(io, position) {
  const { buffer } = await io.read(position, 4);
  const bytes = import_shared.Bytes.view(buffer);
  return bytes.readUInt32BE(0);
}
__name(nvmReadUInt32BE, "nvmReadUInt32BE");
async function nvmReadUInt16BE(io, position) {
  const { buffer } = await io.read(position, 2);
  const bytes = import_shared.Bytes.view(buffer);
  return bytes.readUInt16BE(0);
}
__name(nvmReadUInt16BE, "nvmReadUInt16BE");
async function nvmReadUInt8(io, position) {
  const { buffer } = await io.read(position, 1);
  const bytes = import_shared.Bytes.view(buffer);
  return bytes.readUInt8(0);
}
__name(nvmReadUInt8, "nvmReadUInt8");
async function nvmWriteBuffer(io, position, buffer) {
  const chunkSize = await io.determineChunkSize();
  let offset = 0;
  while (offset < buffer.length) {
    const chunk = buffer.subarray(offset, offset + chunkSize);
    const { bytesWritten } = await io.write(position + offset, chunk);
    offset += bytesWritten;
  }
}
__name(nvmWriteBuffer, "nvmWriteBuffer");
async function nvmReadBuffer(io, position, length) {
  const ret = new Uint8Array(length);
  const chunkSize = await io.determineChunkSize();
  let offset = 0;
  while (offset < length) {
    const { buffer, endOfFile } = await io.read(position + offset, Math.min(chunkSize, length - offset));
    ret.set(buffer, offset);
    offset += buffer.length;
    if (endOfFile)
      break;
  }
  return ret.subarray(0, offset);
}
__name(nvmReadBuffer, "nvmReadBuffer");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  nvmReadBuffer,
  nvmReadUInt16BE,
  nvmReadUInt16LE,
  nvmReadUInt32BE,
  nvmReadUInt32LE,
  nvmReadUInt8,
  nvmWriteBuffer
});
//# sourceMappingURL=utils.js.map
