import { ZWaveError, ZWaveErrorCodes } from "@zwave-js/core";
import { NVMAccess } from "../common/definitions.js";
/** An im-memory implementation of NVMIO */
export class NVMMemoryIO {
    constructor(buffer) {
        this._buffer = buffer;
    }
    _buffer;
    open(_access) {
        // Nothing to do
        return Promise.resolve(NVMAccess.ReadWrite);
    }
    get size() {
        return this._buffer.length;
    }
    get accessMode() {
        return NVMAccess.ReadWrite;
    }
    determineChunkSize() {
        // We can read the entire buffer at once
        return Promise.resolve(this._buffer.length);
    }
    read(offset, length) {
        return Promise.resolve({
            buffer: this._buffer.subarray(offset, offset + length),
            endOfFile: offset + length >= this._buffer.length,
        });
    }
    write(offset, data) {
        if (offset + data.length > this.size) {
            throw new ZWaveError("Write would exceed the NVM size", ZWaveErrorCodes.NVM_NoSpace);
        }
        this._buffer.set(data, offset);
        return Promise.resolve({
            bytesWritten: data.length,
            endOfFile: offset + data.length >= this._buffer.length,
        });
    }
    close() {
        // Nothing to do
        return Promise.resolve();
    }
}
//# sourceMappingURL=NVMMemoryIO.js.map