var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { NodeIDType, RFRegion, ZWaveError, ZWaveErrorCodes, } from "@zwave-js/core";
import { Bytes, getEnumMemberName } from "@zwave-js/shared";
import semverGte from "semver/functions/gte.js";
import semverLt from "semver/functions/lt.js";
import { NVMFile, gotDeserializationOptions, nvmFileID, nvmSection, } from "./NVMFile.js";
export const ApplicationRFConfigFileID = 104;
let ApplicationRFConfigFile = (() => {
    let _classDecorators = [nvmFileID(ApplicationRFConfigFileID), nvmSection("application")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = NVMFile;
    var ApplicationRFConfigFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ApplicationRFConfigFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (gotDeserializationOptions(options)) {
                if (this.payload.length === 3 || this.payload.length === 6) {
                    this.rfRegion = this.payload[0];
                    this.txPower = this.payload.readInt8(1) / 10;
                    this.measured0dBm = this.payload.readInt8(2) / 10;
                    if (this.payload.length === 6) {
                        this.enablePTI = this.payload[3];
                        this.maxTXPower = this.payload.readInt16LE(4) / 10;
                    }
                }
                else if (this.payload.length === 8) {
                    this.rfRegion = this.payload[0];
                    this.txPower = this.payload.readInt16LE(1) / 10;
                    this.measured0dBm = this.payload.readInt16LE(3) / 10;
                    this.enablePTI = this.payload[5];
                    this.maxTXPower = this.payload.readInt16LE(6) / 10;
                }
                else if (this.payload.length === 9) {
                    this.rfRegion = this.payload[0];
                    this.txPower = this.payload.readInt16LE(1) / 10;
                    this.measured0dBm = this.payload.readInt16LE(3) / 10;
                    this.enablePTI = this.payload[5];
                    this.maxTXPower = this.payload.readInt16LE(6) / 10;
                    this.nodeIdType = this.payload[8];
                }
                else {
                    throw new ZWaveError(`ApplicationRFConfigFile has unsupported length ${this.payload.length}`, ZWaveErrorCodes.NVM_NotSupported);
                }
            }
            else {
                this.rfRegion = options.rfRegion;
                this.txPower = options.txPower;
                this.measured0dBm = options.measured0dBm;
                this.enablePTI = options.enablePTI;
                this.maxTXPower = options.maxTXPower;
                this.nodeIdType = options.nodeIdType;
            }
        }
        rfRegion;
        txPower;
        measured0dBm;
        enablePTI;
        maxTXPower;
        nodeIdType;
        serialize() {
            if (semverLt(this.fileVersion, "7.18.1")) {
                this.payload = new Bytes(semverGte(this.fileVersion, "7.15.3") ? 6 : 3).fill(0);
                this.payload[0] = this.rfRegion;
                this.payload.writeIntLE(this.txPower * 10, 1, 1);
                this.payload.writeIntLE(this.measured0dBm * 10, 2, 1);
                if (semverGte(this.fileVersion, "7.15.3")) {
                    this.payload[3] = this.enablePTI ?? 0;
                    this.payload.writeInt16LE((this.maxTXPower ?? 0) * 10, 4);
                }
            }
            else if (semverLt(this.fileVersion, "7.21.0")) {
                this.payload = new Bytes(8).fill(0);
                this.payload[0] = this.rfRegion;
                this.payload.writeInt16LE(this.txPower * 10, 1);
                this.payload.writeInt16LE(this.measured0dBm * 10, 3);
                this.payload[5] = this.enablePTI ?? 0;
                this.payload.writeInt16LE((this.maxTXPower ?? 0) * 10, 6);
            }
            else {
                this.payload = new Bytes(9).fill(0);
                this.payload[0] = this.rfRegion;
                this.payload.writeInt16LE(this.txPower * 10, 1);
                this.payload.writeInt16LE(this.measured0dBm * 10, 3);
                this.payload[5] = this.enablePTI ?? 0;
                this.payload.writeInt16LE((this.maxTXPower ?? 0) * 10, 6);
                this.payload[8] = this.nodeIdType ?? NodeIDType.Short;
            }
            return super.serialize();
        }
        // oxlint-disable-next-line typescript/explicit-module-boundary-types
        toJSON() {
            const ret = {
                ...super.toJSON(),
                "RF Region": getEnumMemberName(RFRegion, this.rfRegion),
                "TX Power": `${this.txPower.toFixed(1)} dBm`,
                "Power @ 0dBm": `${this.measured0dBm.toFixed(1)} dBm`,
            };
            if (this.enablePTI != undefined) {
                ret["enable PTI"] = this.enablePTI;
            }
            if (this.maxTXPower != undefined) {
                ret["max TX power"] = `${this.maxTXPower.toFixed(1)} dBm`;
            }
            if (this.nodeIdType != undefined) {
                ret["node ID type"] = getEnumMemberName(NodeIDType, this.nodeIdType);
            }
            return ret;
        }
    };
    return ApplicationRFConfigFile = _classThis;
})();
export { ApplicationRFConfigFile };
//# sourceMappingURL=ApplicationRFConfigFile.js.map