import { Bytes, type BytesView, type TypedClassDecorator } from "@zwave-js/shared";
import type { NVM3Object } from "../object.js";
export interface NVMFileBaseOptions {
    fileId?: number;
    fileVersion: string;
}
export interface NVMFileDeserializationOptions extends NVMFileBaseOptions {
    fileId: number;
    data: Bytes;
}
export declare function gotDeserializationOptions(options: NVMFileOptions): options is NVMFileDeserializationOptions;
export interface NVMFileCreationOptions extends NVMFileBaseOptions {
}
export type NVMFileOptions = NVMFileCreationOptions | NVMFileDeserializationOptions;
export declare class NVMFile {
    constructor(options: NVMFileOptions);
    protected payload: Bytes;
    fileId: number;
    fileVersion: string;
    /**
     * Creates an instance of the NVM file that is contained in the given NVM object
     */
    static from(fileId: number, data: BytesView, fileVersion: string): NVMFile;
    /**
     * Serializes this NVMFile into an NVM Object
     */
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): Record<string, any>;
}
export type NVMFileConstructor<T extends NVMFile> = typeof NVMFile & {
    new (options: any): T;
};
/**
 * Defines the ID associated with a NVM file class
 */
export declare function nvmFileID<Class extends typeof NVMFile>(id: number | ((id: number) => boolean)): TypedClassDecorator<Class>;
/**
 * Retrieves the file ID defined for a NVM file class
 */
export declare function getNVMFileID<T extends NVMFile>(id: T): number | ((id: number) => boolean);
/**
 * Looks up the NVM file constructor for a given file ID
 */
export declare function getNVMFileConstructor(id: number): NVMFileConstructor<NVMFile> | undefined;
/**
 * Retrieves the file ID defined for a NVM file class
 */
export declare function getNVMFileIDStatic<T extends NVMFileConstructor<NVMFile>>(classConstructor: T): number | ((id: number) => boolean);
export type NVMSection = "application" | "protocol";
/** Defines in which section an NVM file is stored */
export declare const nvmSection: <TTarget extends typeof NVMFile>(section: NVMSection) => TypedClassDecorator<TTarget>;
/** Returns in which section an NVM file is stored (using an instance of the file) */
export declare const getNVMSection: (target: NVMFile) => NVMSection | undefined;
/** Returns in which section an NVM file is stored (using the constructor of the file) */
export declare const getNVMSectionStatic: (constr: typeof NVMFile) => NVMSection | undefined;
/** Returns in which NVM section the file with the given ID resides in */
export declare function getNVMSectionByFileID(fileId: number): NVMSection;
//# sourceMappingURL=NVMFile.d.ts.map