var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MAX_NODES, MAX_REPEATERS } from "@zwave-js/core";
import { Bytes } from "@zwave-js/shared";
import { EMPTY_ROUTECACHE_FILL, ROUTECACHE_SIZE, emptyRouteCache, encodeRoute, parseRoute, } from "../../common/routeCache.js";
import { NVMFile, gotDeserializationOptions, nvmFileID, nvmSection, } from "./NVMFile.js";
export const ROUTECACHES_PER_FILE_V1 = 8;
export const RouteCacheFileV0IDBase = 0x50400;
export function nodeIdToRouteCacheFileIDV0(nodeId) {
    return RouteCacheFileV0IDBase + nodeId - 1;
}
let RouteCacheFileV0 = (() => {
    let _classDecorators = [nvmFileID((id) => id >= RouteCacheFileV0IDBase && id < RouteCacheFileV0IDBase + MAX_NODES), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = NVMFile;
    var RouteCacheFileV0 = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            RouteCacheFileV0 = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (gotDeserializationOptions(options)) {
                const nodeId = this.fileId - RouteCacheFileV0IDBase + 1;
                const lwr = parseRoute(this.payload, 0);
                const nlwr = parseRoute(this.payload, MAX_REPEATERS + 1);
                this.routeCache = { nodeId, lwr, nlwr };
            }
            else {
                this.routeCache = options.routeCache;
            }
        }
        routeCache;
        serialize() {
            this.fileId = nodeIdToRouteCacheFileIDV0(this.routeCache.nodeId);
            this.payload = Bytes.concat([
                encodeRoute(this.routeCache.lwr),
                encodeRoute(this.routeCache.nlwr),
            ]);
            return super.serialize();
        }
        // oxlint-disable-next-line typescript/explicit-module-boundary-types
        toJSON() {
            return {
                ...super.toJSON(),
                routeCache: this.routeCache,
            };
        }
    };
    return RouteCacheFileV0 = _classThis;
})();
export { RouteCacheFileV0 };
export const RouteCacheFileV1IDBase = 0x51400;
export function nodeIdToRouteCacheFileIDV1(nodeId) {
    return (RouteCacheFileV1IDBase
        + Math.floor((nodeId - 1) / ROUTECACHES_PER_FILE_V1));
}
let RouteCacheFileV1 = (() => {
    let _classDecorators = [nvmFileID((id) => id >= RouteCacheFileV1IDBase
            && id < RouteCacheFileV1IDBase + MAX_NODES / ROUTECACHES_PER_FILE_V1), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = NVMFile;
    var RouteCacheFileV1 = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            RouteCacheFileV1 = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (gotDeserializationOptions(options)) {
                this.routeCaches = [];
                for (let i = 0; i < ROUTECACHES_PER_FILE_V1; i++) {
                    const offset = i * 2 * (MAX_REPEATERS + 1);
                    const entry = this.payload.subarray(offset, offset + 2 * (MAX_REPEATERS + 1));
                    if (entry.equals(emptyRouteCache))
                        continue;
                    const nodeId = (this.fileId - RouteCacheFileV1IDBase)
                        * ROUTECACHES_PER_FILE_V1
                        + 1
                        + i;
                    const lwr = parseRoute(this.payload, offset);
                    const nlwr = parseRoute(this.payload, offset + MAX_REPEATERS + 1);
                    this.routeCaches.push({ nodeId, lwr, nlwr });
                }
            }
            else {
                this.routeCaches = options.routeCaches;
            }
        }
        routeCaches;
        serialize() {
            // The route infos must be sorted by node ID
            this.routeCaches.sort((a, b) => a.nodeId - b.nodeId);
            const minNodeId = this.routeCaches[0].nodeId;
            this.fileId = nodeIdToRouteCacheFileIDV1(minNodeId);
            this.payload = new Bytes(ROUTECACHES_PER_FILE_V1 * ROUTECACHE_SIZE)
                .fill(EMPTY_ROUTECACHE_FILL);
            const minFileNodeId = Math.floor((minNodeId - 1) / ROUTECACHES_PER_FILE_V1)
                * ROUTECACHES_PER_FILE_V1
                + 1;
            for (const routeCache of this.routeCaches) {
                const offset = (routeCache.nodeId - minFileNodeId)
                    * ROUTECACHE_SIZE;
                const routes = Bytes.concat([
                    encodeRoute(routeCache.lwr),
                    encodeRoute(routeCache.nlwr),
                ]);
                this.payload.set(routes, offset);
            }
            return super.serialize();
        }
        // oxlint-disable-next-line typescript/explicit-module-boundary-types
        toJSON() {
            return {
                ...super.toJSON(),
                "route caches": this.routeCaches,
            };
        }
    };
    return RouteCacheFileV1 = _classThis;
})();
export { RouteCacheFileV1 };
//# sourceMappingURL=RouteCacheFiles.js.map