import { Bytes } from "@zwave-js/shared";
import { type SUCUpdateEntry } from "../../common/sucUpdateEntry.js";
import type { NVM3Object } from "../object.js";
import { NVMFile, type NVMFileCreationOptions, type NVMFileDeserializationOptions } from "./NVMFile.js";
export declare const SUC_UPDATES_PER_FILE_V5 = 8;
export interface SUCUpdateEntriesFileOptions extends NVMFileCreationOptions {
    updateEntries: SUCUpdateEntry[];
}
export declare const SUCUpdateEntriesFileIDV0 = 327683;
export declare class SUCUpdateEntriesFileV0 extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | SUCUpdateEntriesFileOptions);
    updateEntries: SUCUpdateEntry[];
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        "SUC update entries": SUCUpdateEntry[];
    };
}
export declare const SUCUpdateEntriesFileV5IDBase = 344064;
export declare const SUCUpdateEntriesFileV5IDMax: number;
export declare function sucUpdateIndexToSUCUpdateEntriesFileIDV5(index: number): number;
export declare class SUCUpdateEntriesFileV5 extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | SUCUpdateEntriesFileOptions);
    updateEntries: SUCUpdateEntry[];
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        "SUC update entries": SUCUpdateEntry[];
    };
}
//# sourceMappingURL=SUCUpdateEntriesFile.d.ts.map