import { Bytes } from "@zwave-js/shared";
import { ESPHomeMessage, type ESPHomeMessageBaseOptions, type ESPHomeMessageRaw } from "./ESPHomeMessage.js";
/**
 * ESPHome Z-Wave proxy request types enum
 */
export declare enum ESPHomeZWaveProxyRequestType {
    Subscribe = 0,
    Unsubscribe = 1
}
export interface ZWaveProxyFrameOptions extends ESPHomeMessageBaseOptions {
    data: Bytes;
}
export interface ZWaveProxyRequestOptions extends ESPHomeMessageBaseOptions {
    type: ESPHomeZWaveProxyRequestType;
}
export declare class ZWaveProxyFrame extends ESPHomeMessage {
    constructor(options: ZWaveProxyFrameOptions);
    static from(raw: ESPHomeMessageRaw): ZWaveProxyFrame;
    data: Bytes;
    serialize(): Bytes;
}
export declare class ZWaveProxyRequest extends ESPHomeMessage {
    constructor(options: ZWaveProxyRequestOptions);
    type: ESPHomeZWaveProxyRequestType;
    serialize(): Bytes;
}
//# sourceMappingURL=ZWaveProxyMessages.d.ts.map