/** Indicates the type of a data message */
export declare enum MessageType {
    Request = 0,
    Response = 1
}
/**
 * Complete list of function IDs for data messages.
 * IDs starting with FUNC_ID are straight from OZW and not implemented here yet.
 * IDs starting with UNKNOWN_FUNC are taken from openhab-zwave and not implemented here yet.
 * IDs starting with UNKNOWN_FUNC are also taken from https://github.com/yepher/RaZBerry/blob/master/README.md and not implemented yet
 * IDs ending with UNKNOWN_<hex-code> are reported by the stick but we don't know what they mean.
 */
export declare enum FunctionType {
    GetSerialApiInitData = 2,
    SetApplicationNodeInformation = 3,// Set up the controller NIF prior to starting or joining a Z-Wave network
    ApplicationCommand = 4,// A message from another node
    GetControllerCapabilities = 5,
    SetSerialApiTimeouts = 6,
    GetSerialApiCapabilities = 7,
    SoftReset = 8,
    GetProtocolVersion = 9,// Used to request the Z-Wave Protocol version data (700 series)
    SerialAPIStarted = 10,// Sent by the controller after the serial API has been started (again)
    SerialAPISetup = 11,// Configure the Serial API
    SetRFReceiveMode = 16,// Power the RF section of the stick down/up
    UNKNOWN_FUNC_SET_SLEEP_MODE = 17,// Set the CPU into sleep mode
    SendNodeInformation = 18,// Send Node Information Frame of the stick to a node
    SendData = 19,// Send data
    SendDataMulticast = 20,// Send data using multicast
    GetControllerVersion = 21,
    SendDataAbort = 22,// Abort sending data
    FUNC_ID_ZW_R_F_POWER_LEVEL_SET = 23,// Set RF Power level
    UNKNOWN_FUNC_SEND_DATA_META = 24,// ??
    FUNC_ID_ZW_GET_RANDOM = 28,// Returns random data of variable length
    GetControllerId = 32,// Get Home ID and Controller Node ID
    UNKNOWN_FUNC_MEMORY_GET_BYTE = 33,// get a byte of memory
    UNKNOWN_FUNC_MEMORY_PUT_BYTE = 34,// write a byte of memory
    UNKNOWN_FUNC_MEMORY_GET_BUFFER = 35,
    UNKNOWN_FUNC_MEMORY_PUT_BUFFER = 36,
    EnterBootloader = 39,// Leave Serial API and enter bootloader (700+ series only). Enter Auto-Programming mode (500 series only).
    UNKNOWN_FUNC_UNKNOWN_0x28 = 40,// ZW_NVRGetValue(offset, length) => NVRdata[], see INS13954-13
    GetNVMId = 41,// Returns information about the external NVM
    ExtNVMReadLongBuffer = 42,// Reads a buffer from the external NVM
    ExtNVMWriteLongBuffer = 43,// Writes a buffer to the external NVM
    ExtNVMReadLongByte = 44,// Reads a byte from the external NVM
    ExtExtWriteLongByte = 45,// Writes a byte to the external NVM
    NVMOperations = 46,// Read and write from/to the external NVM (700+ series)
    UNKNOWN_FUNC_CLOCK_SET = 48,// ??
    UNKNOWN_FUNC_CLOCK_GET = 49,// ??
    UNKNOWN_FUNC_CLOCK_COMPARE = 50,// ??
    UNKNOWN_FUNC_RTC_TIMER_CREATE = 51,// ??
    UNKNOWN_FUNC_RTC_TIMER_READ = 52,// ??
    UNKNOWN_FUNC_RTC_TIMER_DELETE = 53,// ??
    UNKNOWN_FUNC_RTC_TIMER_CALL = 54,// ??
    ClearTxTimers = 55,// Reset the Z-Wave module's internal TX timers
    GetTxTimers = 56,// Request the Z-Wave module's internal TX timers
    ClearNetworkStats = 57,// Clear the current Network Statistics collected by the Z-Wave API Module
    GetNetworkStats = 58,// Request the current Network Statistics from the Z-Wave API Module
    GetBackgroundRSSI = 59,// request the most recent background RSSI levels detected
    SetListenBeforeTalkThreshold = 60,// Set the RSSI threshold above which the stick will not transmit
    ExtendedNVMOperations = 61,// Read and write from/to the external NVM with 32-bit addresses (700+ series)
    RemoveSpecificNodeIdFromNetwork = 63,// Trigger removal of a specific node that desires exclusion from the network
    FUNC_ID_ZW_SET_LEARN_NODE_STATE = 64,// Not implemented
    GetNodeProtocolInfo = 65,// Get protocol info (baud rate, listening, etc.) for a given node
    HardReset = 66,// Reset controller and node info to default (original) values
    FUNC_ID_ZW_NEW_CONTROLLER = 67,// Not implemented
    FUNC_ID_ZW_REPLICATION_COMMAND_COMPLETE = 68,// Replication send data complete
    FUNC_ID_ZW_REPLICATION_SEND_DATA = 69,// Replication send data
    AssignReturnRoute = 70,// Assign a return route from the source node to the destination node
    DeleteReturnRoute = 71,// Delete all return routes from the specified node
    RequestNodeNeighborUpdate = 72,// Ask the specified node to update its neighbors (then read them from the controller)
    ApplicationUpdateRequest = 73,// Get a list of supported (and controller) command classes
    AddNodeToNetwork = 74,// Control the addnode (or addcontroller) process...start, stop, etc.
    RemoveNodeFromNetwork = 75,// Control the removenode (or removecontroller) process...start, stop, etc.
    AddControllerAndAssignPrimary = 76,// Include a controller node and assign it the primary controller role. ONLY use from a secondary controller that is SUC.
    AddPrimaryController = 77,// Include a controller node and assign it the primary controller role.
    AssignPriorityReturnRoute = 79,// Assign a priority route between two nodes
    SetLearnMode = 80,// Put a controller into learn mode for replication/ receipt of configuration info
    AssignSUCReturnRoute = 81,// Assign a return route to the SUC
    FUNC_ID_ZW_ENABLE_SUC = 82,// Make a controller a Static Update Controller
    RequestNetworkUpdate = 83,// Request an Automatic Controller Update from the SUC
    SetSUCNodeId = 84,// Configure a static/bridge controller to be a SUC/SIS node (or not)
    DeleteSUCReturnRoute = 85,// Remove return routes to the SUC
    GetSUCNodeId = 86,// Try to retrieve a Static Update Controller node id (zero if no SUC present)
    SendSUCNodeId = 87,// Send the SUC/SIS Node ID from the primary controller to another controller
    AssignPrioritySUCReturnRoute = 88,// Assign a priority route from a node to the SUC
    UNKNOWN_FUNC_REDISCOVERY_NEEDED = 89,
    FUNC_ID_ZW_REQUEST_NODE_NEIGHBOR_UPDATE_OPTIONS = 90,// Allow options for request node neighbor update
    ExploreRequestInclusion = 94,// Initiate network wide inclusion while in learn mode
    ExploreRequestExclusion = 95,// Initiate network wide exclusion while in learn mode
    RequestNodeInfo = 96,// Get info (supported command classes) for the specified node
    RemoveFailedNode = 97,// Mark a specified node id as failed
    IsFailedNode = 98,// Check to see if a specified node has failed
    ReplaceFailedNode = 99,// Replace a failed node with a new one that takes the same node ID
    UNKNOWN_FUNC_UNKNOWN_0x66 = 102,// ??
    UNKNOWN_FUNC_UNKNOWN_0x67 = 103,// ??
    RequestProtocolCCEncryption = 104,// Used by the Z-Wave API module to request encryption of a Z-Wave protocol frame
    UNKNOWN_FUNC_TIMER_START = 112,// ??
    UNKNOWN_FUNC_TIMER_RESTART = 113,// ??
    UNKNOWN_FUNC_TIMER_CANCEL = 114,// ??
    UNKNOWN_FUNC_TIMER_CALL = 115,// ??
    FirmwareUpdateNVM = 120,// Access the NVM section for 500 series OTW firmware updates
    GetRoutingInfo = 128,// Get a specified node's neighbor information from the controller
    UNKNOWN_FUNC_GetTXCounter = 129,// ??
    UNKNOWN_FUNC_ResetTXCounter = 130,// ??
    UNKNOWN_FUNC_StoreNodeInfo = 131,// ??
    UNKNOWN_FUNC_StoreHomeId = 132,// ??
    LockUnlockLastRoute = 144,// Lock or unlock all last working routes
    UNKNOWN_FUNC_SEND_DATA_ROUTE_DEMO = 145,// ??
    GetPriorityRoute = 146,// Get the route that is used as the first routing attempty when transmitting to a node
    SetPriorityRoute = 147,// Set the route that shall be used as the first routing attempty when transmitting to a node
    UNKNOWN_FUNC_SERIAL_API_TEST = 149,// ??
    UNKNOWN_FUNC_UNKNOWN_0x98 = 152,// ??
    VirtualNodeSetNodeInfo = 160,// Set node info of virtual nodes owned by the Z-Wave API module
    FUNC_ID_APPLICATION_SLAVE_COMMAND_HANDLER = 161,// Slave command handler
    VirtualNodeSendNodeInfo = 162,// Send the NIF of a virtual node owned by the Z-Wave API module
    FUNC_ID_ZW_SEND_SLAVE_DATA = 163,// Send data from slave
    VirtualNodeSetLearnMode = 164,// Put a virtual node into learn mode
    GetVirtualNodes = 165,// Return all virtual nodes
    IsVirtualNode = 166,// Test if a given node ID is a virtual node
    BridgeApplicationCommand = 168,// A message from another node using the Bridge API
    SendDataBridge = 169,// Send data (Bridge API)
    SendDataMulticastBridge = 171,// Send data using multicast (Bridge API)
    EnableWatchdog500 = 182,// Enable Watchdog (500 series and older)
    DisableWatchdog500 = 183,// Disable Watchdog (500 series and older)
    KickWatchdog500 = 184,// Kick Watchdog (500 series and older)
    UNKNOWN_FUNC_UNKNOWN_0xB9 = 185,// ??
    UNKNOWN_FUNC_RF_POWERLEVEL_GET = 186,// Get RF Power level
    GetLibrary = 189,// Request the Z-Wave library type running on the Z-Wave module
    SendTestFrame = 190,// Sends a NOP Power frame to the given node
    GetProtocolStatus = 191,// Request the current status of the protocol running on the Z-Wave module
    FUNC_ID_ZW_SET_PROMISCUOUS_MODE = 208,// Set controller into promiscuous mode to listen to all messages
    FUNC_ID_PROMISCUOUS_APPLICATION_COMMAND_HANDLER = 209,// deprecated, replaced with a flag for the ApplicationCommandHandler
    StartWatchdog = 210,// Start Hardware Watchdog (700 series and newer)
    StopWatchdog = 211,// Stop Hardware Watchdog (700 series and newer)
    SetMaximumRoutingAttempts = 212,// Set the maximum number of source routing attempts
    SetMaxSmartStartInclusionRequestInterval = 214,// Set the maximum interval between SmartStart inclusion requests
    Shutdown = 217,// Instruct the Z-Wave API to shut down in order to safely remove the power
    GetLongRangeNodes = 218,// Used after GetSerialApiInitData to get the nodes with IDs > 0xFF
    GetLongRangeChannel = 219,
    SetLongRangeChannel = 220,
    SetLongRangeShadowNodeIDs = 221,
    Proprietary_DE = 222,
    Proprietary_DF = 223,
    Proprietary_E7 = 231,
    Proprietary_E8 = 232,
    Proprietary_F0 = 240,
    Proprietary_F1 = 241,
    Proprietary_F2 = 242,
    Proprietary_F3 = 243,
    Proprietary_F4 = 244,
    Proprietary_F5 = 245,
    Proprietary_F6 = 246,
    Proprietary_F7 = 247,
    Proprietary_F8 = 248,
    Proprietary_F9 = 249,
    Proprietary_FA = 250,
    Proprietary_FB = 251,
    Proprietary_FC = 252,
    Proprietary_FD = 253,
    Proprietary_FE = 254
}
export declare enum ZnifferFunctionType {
    GetVersion = 1,
    SetFrequency = 2,
    GetFrequencies = 3,
    Start = 4,
    Stop = 5,
    SetLRChannelConfig = 6,
    GetLRChannelConfigs = 7,
    GetLRRegions = 8,
    SetBaudRate = 14,
    GetFrequencyInfo = 19,
    GetLRChannelConfigInfo = 20
}
export declare enum ZnifferMessageType {
    Command = 35,
    Data = 33
}
export declare enum ZnifferFrameType {
    Command = 0,
    Data = 1,
    BeamFrame = 2,
    BeamStart = 4,
    BeamStop = 5
}
//# sourceMappingURL=Constants.d.ts.map