"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BootloaderParsers_exports = {};
__export(BootloaderParsers_exports, {
  BootloaderParser: () => BootloaderParser,
  BootloaderScreenParser: () => BootloaderScreenParser,
  bootloaderMenuPreamble: () => bootloaderMenuPreamble
});
module.exports = __toCommonJS(BootloaderParsers_exports);
var import_shared = require("@zwave-js/shared");
var import_MessageHeaders = require("../message/MessageHeaders.js");
var import_ZWaveSerialFrame = require("./ZWaveSerialFrame.js");
function isFlowControl(byte) {
  return byte === import_MessageHeaders.XModemMessageHeaders.ACK || byte === import_MessageHeaders.XModemMessageHeaders.NAK || byte === import_MessageHeaders.XModemMessageHeaders.CAN || byte === import_MessageHeaders.XModemMessageHeaders.C;
}
__name(isFlowControl, "isFlowControl");
class BootloaderScreenParserTransformer {
  static {
    __name(this, "BootloaderScreenParserTransformer");
  }
  logger;
  constructor(logger) {
    this.logger = logger;
  }
  receiveBuffer = "";
  flushTimeout;
  transform(chunk, controller) {
    this.flushTimeout?.clear();
    this.flushTimeout = void 0;
    this.receiveBuffer += import_shared.Bytes.view(chunk).toString("utf8");
    this.receiveBuffer = this.receiveBuffer.replaceAll(/(error 0x)\0([0-9a-f]+)/gi, "$1$2\0");
    let nulCharIndex;
    while ((nulCharIndex = this.receiveBuffer.indexOf("\0")) > -1) {
      const screen = this.receiveBuffer.slice(0, nulCharIndex).trim();
      this.receiveBuffer = this.receiveBuffer.slice(nulCharIndex + 1);
      if (screen === "")
        continue;
      this.logger?.bootloaderScreen(screen);
      controller.enqueue(screen);
    }
    while (this.receiveBuffer.length > 0) {
      const charCode = this.receiveBuffer.charCodeAt(0);
      if (!isFlowControl(charCode))
        break;
      this.logger?.data("inbound", Uint8Array.from([charCode]));
      controller.enqueue(charCode);
      this.receiveBuffer = this.receiveBuffer.slice(1);
    }
    if (this.receiveBuffer) {
      this.flushTimeout = (0, import_shared.setTimer)(() => {
        this.flushTimeout = void 0;
        try {
          controller.enqueue(this.receiveBuffer);
        } catch {
        }
        this.receiveBuffer = "";
      }, 500);
    }
  }
}
class BootloaderScreenParser extends TransformStream {
  static {
    __name(this, "BootloaderScreenParser");
  }
  constructor(logger) {
    super(new BootloaderScreenParserTransformer(logger));
  }
}
const bootloaderMenuPreamble = "Gecko Boo";
const preambleRegex = /^Gecko Bootloader v(?<version>\d+\.\d+\.\d+)/;
const menuSuffix = "BL >";
const optionsRegex = /^(?<num>\d+)\. (?<option>.+)/gm;
class BootloaderParser extends TransformStream {
  static {
    __name(this, "BootloaderParser");
  }
  constructor() {
    function wrapChunk(chunk) {
      return {
        type: import_ZWaveSerialFrame.ZWaveSerialFrameType.Bootloader,
        data: chunk
      };
    }
    __name(wrapChunk, "wrapChunk");
    const transformer = {
      transform(chunk, controller) {
        if (typeof chunk === "number") {
          controller.enqueue(wrapChunk({
            type: import_ZWaveSerialFrame.BootloaderChunkType.FlowControl,
            command: chunk
          }));
          return;
        }
        let screen = chunk.trim();
        const menuPreambleIndex = screen.indexOf(bootloaderMenuPreamble);
        if (menuPreambleIndex > -1 && screen.endsWith(menuSuffix)) {
          screen = screen.slice(menuPreambleIndex);
          const version = preambleRegex.exec(screen)?.groups?.version;
          if (!version) {
            controller.enqueue(
              wrapChunk({
                type: import_ZWaveSerialFrame.BootloaderChunkType.Error,
                error: "Could not determine bootloader version",
                _raw: screen
              })
              /* satisfies BootloaderChunk */
            );
            return;
          }
          const options = [];
          let match;
          while ((match = optionsRegex.exec(screen)) !== null) {
            options.push({
              num: parseInt(match.groups.num),
              option: match.groups.option
            });
          }
          controller.enqueue(wrapChunk({
            type: import_ZWaveSerialFrame.BootloaderChunkType.Menu,
            _raw: screen,
            version,
            options
          }));
        } else {
          controller.enqueue(wrapChunk({
            type: import_ZWaveSerialFrame.BootloaderChunkType.Message,
            _raw: screen,
            message: screen
          }));
        }
      }
    };
    super(transformer);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BootloaderParser,
  BootloaderScreenParser,
  bootloaderMenuPreamble
});
//# sourceMappingURL=BootloaderParsers.js.map
