"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ApplicationUpdateRequest_exports = {};
__export(ApplicationUpdateRequest_exports, {
  ApplicationUpdateRequest: () => ApplicationUpdateRequest,
  ApplicationUpdateRequestNodeAdded: () => ApplicationUpdateRequestNodeAdded,
  ApplicationUpdateRequestNodeInfoReceived: () => ApplicationUpdateRequestNodeInfoReceived,
  ApplicationUpdateRequestNodeInfoRequestFailed: () => ApplicationUpdateRequestNodeInfoRequestFailed,
  ApplicationUpdateRequestNodeRemoved: () => ApplicationUpdateRequestNodeRemoved,
  ApplicationUpdateRequestSUCIdChanged: () => ApplicationUpdateRequestSUCIdChanged,
  ApplicationUpdateRequestSmartStartHomeIDReceived: () => ApplicationUpdateRequestSmartStartHomeIDReceived,
  ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived: () => ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived,
  ApplicationUpdateRequestWithNodeInfo: () => ApplicationUpdateRequestWithNodeInfo,
  ApplicationUpdateTypes: () => ApplicationUpdateTypes
});
module.exports = __toCommonJS(ApplicationUpdateRequest_exports);
var import_core = require("@zwave-js/core");
var import_reflection = require("@zwave-js/core/reflection");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var ApplicationUpdateTypes;
(function(ApplicationUpdateTypes2) {
  ApplicationUpdateTypes2[ApplicationUpdateTypes2["SmartStart_NodeInfo_Received"] = 134] = "SmartStart_NodeInfo_Received";
  ApplicationUpdateTypes2[ApplicationUpdateTypes2["SmartStart_HomeId_Received"] = 133] = "SmartStart_HomeId_Received";
  ApplicationUpdateTypes2[ApplicationUpdateTypes2["SmartStart_LongRange_HomeId_Received"] = 135] = "SmartStart_LongRange_HomeId_Received";
  ApplicationUpdateTypes2[ApplicationUpdateTypes2["NodeInfo_Received"] = 132] = "NodeInfo_Received";
  ApplicationUpdateTypes2[ApplicationUpdateTypes2["NodeInfo_RequestDone"] = 130] = "NodeInfo_RequestDone";
  ApplicationUpdateTypes2[ApplicationUpdateTypes2["NodeInfo_RequestFailed"] = 129] = "NodeInfo_RequestFailed";
  ApplicationUpdateTypes2[ApplicationUpdateTypes2["RoutingPending"] = 128] = "RoutingPending";
  ApplicationUpdateTypes2[ApplicationUpdateTypes2["Node_Added"] = 64] = "Node_Added";
  ApplicationUpdateTypes2[ApplicationUpdateTypes2["Node_Removed"] = 32] = "Node_Removed";
  ApplicationUpdateTypes2[ApplicationUpdateTypes2["SUC_IdChanged"] = 16] = "SUC_IdChanged";
})(ApplicationUpdateTypes || (ApplicationUpdateTypes = {}));
const { decorator: applicationUpdateType, lookupConstructor: getApplicationUpdateRequestConstructor, lookupValue: getApplicationUpdateType } = (0, import_reflection.createSimpleReflectionDecorator)({
  name: "applicationUpdateType"
});
let ApplicationUpdateRequest = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.ApplicationUpdateRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var ApplicationUpdateRequest2 = class extends _classSuper {
    static {
      __name(this, "ApplicationUpdateRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationUpdateRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options = {}) {
      super(options);
      this.updateType = options.updateType ?? getApplicationUpdateType(this);
    }
    static from(raw, ctx) {
      const updateType = raw.payload[0];
      const payload = raw.payload.subarray(1);
      const CommandConstructor = getApplicationUpdateRequestConstructor(updateType);
      if (CommandConstructor) {
        return CommandConstructor.from(raw.withPayload(payload), ctx);
      }
      const ret = new ApplicationUpdateRequest2({
        updateType
      });
      ret.payload = payload;
      return ret;
    }
    updateType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.updateType]),
        this.payload
      ]);
      return super.serialize(ctx);
    }
  };
  return ApplicationUpdateRequest2 = _classThis;
})();
class ApplicationUpdateRequestWithNodeInfo extends ApplicationUpdateRequest {
  static {
    __name(this, "ApplicationUpdateRequestWithNodeInfo");
  }
  constructor(options) {
    super(options);
    this.nodeId = options.nodeInformation.nodeId;
    this.nodeInformation = options.nodeInformation;
  }
  static from(raw, ctx) {
    const nodeInformation = (0, import_core.parseNodeUpdatePayload)(raw.payload, ctx.nodeIdType);
    return new this({
      nodeInformation
    });
  }
  nodeId;
  nodeInformation;
  serialize(ctx) {
    this.payload = (0, import_core.encodeNodeUpdatePayload)(this.nodeInformation, ctx.nodeIdType);
    return super.serialize(ctx);
  }
}
let ApplicationUpdateRequestNodeInfoReceived = (() => {
  let _classDecorators = [applicationUpdateType(ApplicationUpdateTypes.NodeInfo_Received)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ApplicationUpdateRequestWithNodeInfo;
  var ApplicationUpdateRequestNodeInfoReceived2 = class extends _classSuper {
    static {
      __name(this, "ApplicationUpdateRequestNodeInfoReceived");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationUpdateRequestNodeInfoReceived2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ApplicationUpdateRequestNodeInfoReceived2 = _classThis;
})();
let ApplicationUpdateRequestNodeInfoRequestFailed = (() => {
  let _classDecorators = [applicationUpdateType(ApplicationUpdateTypes.NodeInfo_RequestFailed)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ApplicationUpdateRequest;
  var ApplicationUpdateRequestNodeInfoRequestFailed2 = class extends _classSuper {
    static {
      __name(this, "ApplicationUpdateRequestNodeInfoRequestFailed");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationUpdateRequestNodeInfoRequestFailed2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    isOK() {
      return false;
    }
  };
  return ApplicationUpdateRequestNodeInfoRequestFailed2 = _classThis;
})();
let ApplicationUpdateRequestNodeAdded = (() => {
  let _classDecorators = [applicationUpdateType(ApplicationUpdateTypes.Node_Added)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ApplicationUpdateRequestWithNodeInfo;
  var ApplicationUpdateRequestNodeAdded2 = class extends _classSuper {
    static {
      __name(this, "ApplicationUpdateRequestNodeAdded");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationUpdateRequestNodeAdded2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ApplicationUpdateRequestNodeAdded2 = _classThis;
})();
let ApplicationUpdateRequestNodeRemoved = (() => {
  let _classDecorators = [applicationUpdateType(ApplicationUpdateTypes.Node_Removed)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ApplicationUpdateRequest;
  var ApplicationUpdateRequestNodeRemoved2 = class extends _classSuper {
    static {
      __name(this, "ApplicationUpdateRequestNodeRemoved");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationUpdateRequestNodeRemoved2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.nodeId = options.nodeId;
    }
    static from(raw, ctx) {
      const { nodeId } = (0, import_core.parseNodeID)(raw.payload, ctx.nodeIdType, 0);
      return new this({
        nodeId
      });
    }
    nodeId;
  };
  return ApplicationUpdateRequestNodeRemoved2 = _classThis;
})();
class ApplicationUpdateRequestSmartStartHomeIDReceivedBase extends ApplicationUpdateRequest {
  static {
    __name(this, "ApplicationUpdateRequestSmartStartHomeIDReceivedBase");
  }
  constructor(options) {
    super(options);
    this.remoteNodeId = options.remoteNodeId;
    this.nwiHomeId = options.nwiHomeId;
    this.basicDeviceClass = options.basicDeviceClass;
    this.genericDeviceClass = options.genericDeviceClass;
    this.specificDeviceClass = options.specificDeviceClass;
    this.supportedCCs = options.supportedCCs;
  }
  static from(raw, ctx) {
    let offset = 0;
    const { nodeId: remoteNodeId, bytesRead: nodeIdBytes } = (0, import_core.parseNodeID)(raw.payload, ctx.nodeIdType, offset);
    offset += nodeIdBytes;
    offset++;
    const nwiHomeId = raw.payload.subarray(offset, offset + 4);
    offset += 4;
    const ccLength = raw.payload[offset++];
    const basicDeviceClass = raw.payload[offset++];
    const genericDeviceClass = raw.payload[offset++];
    const specificDeviceClass = raw.payload[offset++];
    const supportedCCs = (0, import_core.parseCCList)(raw.payload.subarray(offset, offset + ccLength)).supportedCCs;
    return new this({
      remoteNodeId,
      nwiHomeId,
      basicDeviceClass,
      genericDeviceClass,
      specificDeviceClass,
      supportedCCs
    });
  }
  remoteNodeId;
  nwiHomeId;
  basicDeviceClass;
  genericDeviceClass;
  specificDeviceClass;
  supportedCCs;
  toLogEntry() {
    const message = {
      type: (0, import_shared.getEnumMemberName)(ApplicationUpdateTypes, this.updateType),
      "remote node ID": this.remoteNodeId,
      "NWI home ID": (0, import_shared.buffer2hex)(this.nwiHomeId),
      "basic device class": (0, import_shared.getEnumMemberName)(import_core.BasicDeviceClass, this.basicDeviceClass),
      "generic device class": this.genericDeviceClass,
      "specific device class": this.specificDeviceClass,
      "supported CCs": this.supportedCCs.map((cc) => `
\xB7 ${(0, import_core.getCCName)(cc)}`).join("")
    };
    return {
      ...super.toLogEntry(),
      message
    };
  }
}
let ApplicationUpdateRequestSmartStartHomeIDReceived = (() => {
  let _classDecorators = [applicationUpdateType(ApplicationUpdateTypes.SmartStart_HomeId_Received)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ApplicationUpdateRequestSmartStartHomeIDReceivedBase;
  var ApplicationUpdateRequestSmartStartHomeIDReceived2 = class extends _classSuper {
    static {
      __name(this, "ApplicationUpdateRequestSmartStartHomeIDReceived");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationUpdateRequestSmartStartHomeIDReceived2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ApplicationUpdateRequestSmartStartHomeIDReceived2 = _classThis;
})();
let ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived = (() => {
  let _classDecorators = [applicationUpdateType(ApplicationUpdateTypes.SmartStart_LongRange_HomeId_Received)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ApplicationUpdateRequestSmartStartHomeIDReceivedBase;
  var ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived2 = class extends _classSuper {
    static {
      __name(this, "ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived2 = _classThis;
})();
let ApplicationUpdateRequestSUCIdChanged = (() => {
  let _classDecorators = [applicationUpdateType(ApplicationUpdateTypes.SUC_IdChanged)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ApplicationUpdateRequest;
  var ApplicationUpdateRequestSUCIdChanged2 = class extends _classSuper {
    static {
      __name(this, "ApplicationUpdateRequestSUCIdChanged");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationUpdateRequestSUCIdChanged2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.sucNodeID = options.sucNodeID;
    }
    static from(raw, ctx) {
      const { nodeId: sucNodeID } = (0, import_core.parseNodeID)(raw.payload, ctx.nodeIdType, 0);
      return new this({
        sucNodeID
      });
    }
    sucNodeID;
    toLogEntry() {
      const message = {
        type: (0, import_shared.getEnumMemberName)(ApplicationUpdateTypes, this.updateType),
        "SUC node ID": this.sucNodeID
      };
      return {
        ...super.toLogEntry(),
        message
      };
    }
  };
  return ApplicationUpdateRequestSUCIdChanged2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ApplicationUpdateRequest,
  ApplicationUpdateRequestNodeAdded,
  ApplicationUpdateRequestNodeInfoReceived,
  ApplicationUpdateRequestNodeInfoRequestFailed,
  ApplicationUpdateRequestNodeRemoved,
  ApplicationUpdateRequestSUCIdChanged,
  ApplicationUpdateRequestSmartStartHomeIDReceived,
  ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived,
  ApplicationUpdateRequestWithNodeInfo,
  ApplicationUpdateTypes
});
//# sourceMappingURL=ApplicationUpdateRequest.js.map
