import { type BasicDeviceClass, type DataRate, type FLiRS, type NodeProtocolInfoAndDeviceClass, type NodeType, type ProtocolVersion } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export interface GetNodeProtocolInfoRequestOptions {
    requestedNodeId: number;
}
export declare class GetNodeProtocolInfoRequest extends Message {
    constructor(options: GetNodeProtocolInfoRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): GetNodeProtocolInfoRequest;
    requestedNodeId: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
export interface GetNodeProtocolInfoResponseOptions extends NodeProtocolInfoAndDeviceClass {
}
export declare class GetNodeProtocolInfoResponse extends Message {
    constructor(options: GetNodeProtocolInfoResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): GetNodeProtocolInfoResponse;
    /** Whether this node is always listening or not */
    isListening: boolean;
    /** Indicates the wakeup interval if this node is a FLiRS node. `false` if it isn't. */
    isFrequentListening: FLiRS;
    /** Whether the node supports routing/forwarding messages. */
    isRouting: boolean;
    supportedDataRates: DataRate[];
    protocolVersion: ProtocolVersion;
    /** Whether this node supports additional CCs besides the mandatory minimum */
    optionalFunctionality: boolean;
    /** Whether this node is a controller (can calculate routes) or an end node (relies on route info) */
    nodeType: NodeType;
    /** Whether this node supports security (S0 or S2) */
    supportsSecurity: boolean;
    /** Whether this node can issue wakeup beams to FLiRS nodes */
    supportsBeaming: boolean;
    basicDeviceClass: BasicDeviceClass;
    genericDeviceClass: number;
    specificDeviceClass: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
//# sourceMappingURL=GetNodeProtocolInfoMessages.d.ts.map