import { type MessageOrCCLogEntry, RouteKind, ZWaveDataRate } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { type Bytes } from "@zwave-js/shared";
export interface GetPriorityRouteRequestOptions {
    destinationNodeId: number;
}
export declare class GetPriorityRouteRequest extends Message {
    constructor(options: GetPriorityRouteRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): GetPriorityRouteRequest;
    destinationNodeId: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface GetPriorityRouteResponseOptions {
    destinationNodeId: number;
    routeKind: RouteKind;
    repeaters?: number[];
    routeSpeed?: ZWaveDataRate;
}
export declare class GetPriorityRouteResponse extends Message {
    constructor(options: GetPriorityRouteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): GetPriorityRouteResponse;
    readonly destinationNodeId: number;
    readonly routeKind: RouteKind;
    readonly repeaters?: number[];
    readonly routeSpeed?: ZWaveDataRate;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=GetPriorityRouteMessages.d.ts.map