"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var RemoveNodeFromNetworkRequest_exports = {};
__export(RemoveNodeFromNetworkRequest_exports, {
  RemoveNodeFromNetworkRequest: () => RemoveNodeFromNetworkRequest,
  RemoveNodeFromNetworkRequestBase: () => RemoveNodeFromNetworkRequestBase,
  RemoveNodeFromNetworkRequestStatusReport: () => RemoveNodeFromNetworkRequestStatusReport,
  RemoveNodeStatus: () => RemoveNodeStatus,
  RemoveNodeType: () => RemoveNodeType
});
module.exports = __toCommonJS(RemoveNodeFromNetworkRequest_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var RemoveNodeType;
(function(RemoveNodeType2) {
  RemoveNodeType2[RemoveNodeType2["Any"] = 1] = "Any";
  RemoveNodeType2[RemoveNodeType2["Controller"] = 2] = "Controller";
  RemoveNodeType2[RemoveNodeType2["Slave"] = 3] = "Slave";
  RemoveNodeType2[RemoveNodeType2["Stop"] = 5] = "Stop";
})(RemoveNodeType || (RemoveNodeType = {}));
var RemoveNodeStatus;
(function(RemoveNodeStatus2) {
  RemoveNodeStatus2[RemoveNodeStatus2["Ready"] = 1] = "Ready";
  RemoveNodeStatus2[RemoveNodeStatus2["NodeFound"] = 2] = "NodeFound";
  RemoveNodeStatus2[RemoveNodeStatus2["RemovingSlave"] = 3] = "RemovingSlave";
  RemoveNodeStatus2[RemoveNodeStatus2["RemovingController"] = 4] = "RemovingController";
  RemoveNodeStatus2[RemoveNodeStatus2["Reserved_0x05"] = 5] = "Reserved_0x05";
  RemoveNodeStatus2[RemoveNodeStatus2["Done"] = 6] = "Done";
  RemoveNodeStatus2[RemoveNodeStatus2["Failed"] = 7] = "Failed";
})(RemoveNodeStatus || (RemoveNodeStatus = {}));
var RemoveNodeFlags;
(function(RemoveNodeFlags2) {
  RemoveNodeFlags2[RemoveNodeFlags2["HighPower"] = 128] = "HighPower";
  RemoveNodeFlags2[RemoveNodeFlags2["NetworkWide"] = 64] = "NetworkWide";
})(RemoveNodeFlags || (RemoveNodeFlags = {}));
let RemoveNodeFromNetworkRequestBase = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.RemoveNodeFromNetwork), (0, import_serial.priority)(import_core.MessagePriority.Controller)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var RemoveNodeFromNetworkRequestBase2 = class extends _classSuper {
    static {
      __name(this, "RemoveNodeFromNetworkRequestBase");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      RemoveNodeFromNetworkRequestBase2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      if (ctx.origin === import_serial.MessageOrigin.Host) {
        return RemoveNodeFromNetworkRequest.from(raw, ctx);
      } else {
        return RemoveNodeFromNetworkRequestStatusReport.from(raw, ctx);
      }
    }
  };
  return RemoveNodeFromNetworkRequestBase2 = _classThis;
})();
function testCallbackForRemoveNodeRequest(sent, received) {
  if (!(received instanceof RemoveNodeFromNetworkRequestStatusReport)) {
    return false;
  }
  switch (sent.removeNodeType) {
    case RemoveNodeType.Any:
    case RemoveNodeType.Controller:
    case RemoveNodeType.Slave:
      return received.status === RemoveNodeStatus.Ready || received.status === RemoveNodeStatus.Failed;
    case RemoveNodeType.Stop:
      return received.status === RemoveNodeStatus.Done || received.status === RemoveNodeStatus.Reserved_0x05 || received.status === RemoveNodeStatus.Failed;
    default:
      return false;
  }
}
__name(testCallbackForRemoveNodeRequest, "testCallbackForRemoveNodeRequest");
let RemoveNodeFromNetworkRequest = (() => {
  let _classDecorators = [(0, import_serial.expectedCallback)(testCallbackForRemoveNodeRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = RemoveNodeFromNetworkRequestBase;
  var RemoveNodeFromNetworkRequest2 = class extends _classSuper {
    static {
      __name(this, "RemoveNodeFromNetworkRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      RemoveNodeFromNetworkRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.removeNodeType = options.removeNodeType;
      this.highPower = !!options.highPower;
      this.networkWide = !!options.networkWide;
    }
    static from(raw, _ctx) {
      const highPower = !!(raw.payload[0] & RemoveNodeFlags.HighPower);
      const networkWide = !!(raw.payload[0] & RemoveNodeFlags.NetworkWide);
      const removeNodeType = raw.payload[0] & 31;
      const callbackId = raw.payload[1];
      return new this({
        callbackId,
        removeNodeType,
        highPower,
        networkWide
      });
    }
    /** The type of node to remove */
    removeNodeType;
    /** Whether to use high power */
    highPower = false;
    /** Whether to exclude network wide */
    networkWide = false;
    serialize(ctx) {
      this.assertCallbackId();
      let data = this.removeNodeType || RemoveNodeType.Any;
      if (this.highPower)
        data |= RemoveNodeFlags.HighPower;
      if (this.networkWide)
        data |= RemoveNodeFlags.NetworkWide;
      this.payload = import_shared.Bytes.from([data, this.callbackId]);
      return super.serialize(ctx);
    }
  };
  return RemoveNodeFromNetworkRequest2 = _classThis;
})();
class RemoveNodeFromNetworkRequestStatusReport extends RemoveNodeFromNetworkRequestBase {
  static {
    __name(this, "RemoveNodeFromNetworkRequestStatusReport");
  }
  constructor(options) {
    super(options);
    this.status = options.status;
    if ("nodeId" in options) {
      this.statusContext = { nodeId: options.nodeId };
    }
  }
  static from(raw, ctx) {
    const callbackId = raw.payload[0];
    const status = raw.payload[1];
    switch (status) {
      case RemoveNodeStatus.Ready:
      case RemoveNodeStatus.NodeFound:
      case RemoveNodeStatus.Failed:
      case RemoveNodeStatus.Reserved_0x05:
      case RemoveNodeStatus.Done:
        return new this({
          callbackId,
          status
        });
      case RemoveNodeStatus.RemovingController:
      case RemoveNodeStatus.RemovingSlave: {
        const { nodeId } = (0, import_core.parseNodeID)(raw.payload.subarray(2), ctx.nodeIdType);
        return new this({
          callbackId,
          status,
          nodeId
        });
      }
    }
  }
  status;
  statusContext;
  isOK() {
    return this.status !== RemoveNodeStatus.Failed;
  }
  serialize(ctx) {
    this.assertCallbackId();
    this.payload = import_shared.Bytes.from([this.callbackId, this.status]);
    if (this.statusContext?.nodeId != void 0) {
      this.payload = import_shared.Bytes.concat([
        this.payload,
        (0, import_core.encodeNodeID)(this.statusContext.nodeId, ctx.nodeIdType)
      ]);
    }
    return super.serialize(ctx);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  RemoveNodeFromNetworkRequest,
  RemoveNodeFromNetworkRequestBase,
  RemoveNodeFromNetworkRequestStatusReport,
  RemoveNodeStatus,
  RemoveNodeType
});
//# sourceMappingURL=RemoveNodeFromNetworkRequest.js.map
