"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SetLearnModeMessages_exports = {};
__export(SetLearnModeMessages_exports, {
  LearnModeIntent: () => LearnModeIntent,
  LearnModeStatus: () => LearnModeStatus,
  SetLearnModeCallback: () => SetLearnModeCallback,
  SetLearnModeRequest: () => SetLearnModeRequest,
  SetLearnModeRequestBase: () => SetLearnModeRequestBase,
  SetLearnModeResponse: () => SetLearnModeResponse
});
module.exports = __toCommonJS(SetLearnModeMessages_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
const LEARN_MODE_EMPTY_NODE_ID = 239;
var LearnModeIntent;
(function(LearnModeIntent2) {
  LearnModeIntent2[LearnModeIntent2["LegacyStop"] = 0] = "LegacyStop";
  LearnModeIntent2[LearnModeIntent2["LegacyInclusionExclusion"] = 1] = "LegacyInclusionExclusion";
  LearnModeIntent2[LearnModeIntent2["LegacyNetworkWideInclusion"] = 2] = "LegacyNetworkWideInclusion";
  LearnModeIntent2[LearnModeIntent2["LegacyNetworkWideExclusion"] = 3] = "LegacyNetworkWideExclusion";
  LearnModeIntent2[LearnModeIntent2["Stop"] = 128] = "Stop";
  LearnModeIntent2[LearnModeIntent2["Inclusion"] = 129] = "Inclusion";
  LearnModeIntent2[LearnModeIntent2["DirectExclusion"] = 130] = "DirectExclusion";
  LearnModeIntent2[LearnModeIntent2["NetworkWideExclusion"] = 131] = "NetworkWideExclusion";
  LearnModeIntent2[LearnModeIntent2["SmartStart"] = 132] = "SmartStart";
})(LearnModeIntent || (LearnModeIntent = {}));
var LearnModeStatus;
(function(LearnModeStatus2) {
  LearnModeStatus2[LearnModeStatus2["Started"] = 1] = "Started";
  LearnModeStatus2[LearnModeStatus2["ProtocolDone"] = 5] = "ProtocolDone";
  LearnModeStatus2[LearnModeStatus2["Completed"] = 6] = "Completed";
  LearnModeStatus2[LearnModeStatus2["Failed"] = 7] = "Failed";
})(LearnModeStatus || (LearnModeStatus = {}));
let SetLearnModeRequestBase = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.SetLearnMode), (0, import_serial.priority)(import_core.MessagePriority.Controller)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SetLearnModeRequestBase2 = class extends _classSuper {
    static {
      __name(this, "SetLearnModeRequestBase");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SetLearnModeRequestBase2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      if (ctx.origin === import_serial.MessageOrigin.Host) {
        return SetLearnModeRequest.from(raw, ctx);
      } else {
        return SetLearnModeCallback.from(raw, ctx);
      }
    }
  };
  return SetLearnModeRequestBase2 = _classThis;
})();
let SetLearnModeRequest = (() => {
  let _classDecorators = [(0, import_serial.expectedResponse)(import_serial.FunctionType.SetLearnMode)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SetLearnModeRequestBase;
  var SetLearnModeRequest2 = class extends _classSuper {
    static {
      __name(this, "SetLearnModeRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SetLearnModeRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.intent = options.intent;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    intent;
    serialize(ctx) {
      this.assertCallbackId();
      this.payload = import_shared.Bytes.from([
        this.intent,
        this.callbackId
      ]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: {
          "callback id": this.callbackId ?? "(not set)",
          intent: (0, import_shared.getEnumMemberName)(LearnModeIntent, this.intent)
        }
      };
    }
  };
  return SetLearnModeRequest2 = _classThis;
})();
let SetLearnModeResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.SetLearnMode)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SetLearnModeResponse2 = class extends _classSuper {
    static {
      __name(this, "SetLearnModeResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SetLearnModeResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.success = options.success;
    }
    static from(raw, _ctx) {
      const success = raw.payload[0] !== 0;
      return new this({
        success
      });
    }
    success;
    isOK() {
      return this.success;
    }
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: { success: this.success }
      };
    }
  };
  return SetLearnModeResponse2 = _classThis;
})();
class SetLearnModeCallback extends SetLearnModeRequestBase {
  static {
    __name(this, "SetLearnModeCallback");
  }
  constructor(options) {
    super(options);
    this.callbackId = options.callbackId;
    this.status = options.status;
    this.assignedNodeId = options.assignedNodeId;
    this.statusMessage = options.statusMessage;
  }
  static from(raw, _ctx) {
    const callbackId = raw.payload[0];
    const status = raw.payload[1];
    const assignedNodeId = raw.payload[2];
    let statusMessage;
    if (raw.payload.length > 3) {
      const msgLength = raw.payload[3];
      statusMessage = raw.payload.subarray(4, 4 + msgLength);
    }
    return new this({
      callbackId,
      status,
      assignedNodeId,
      statusMessage
    });
  }
  status;
  assignedNodeId;
  statusMessage;
  isOK() {
    return this.status !== LearnModeStatus.Failed;
  }
  toLogEntry() {
    const message = {
      "callback id": this.callbackId ?? "(not set)",
      status: (0, import_shared.getEnumMemberName)(LearnModeStatus, this.status)
    };
    if (this.status !== LearnModeStatus.Started || this.assignedNodeId !== LEARN_MODE_EMPTY_NODE_ID) {
      message["assigned node id"] = this.assignedNodeId;
    }
    if (this.statusMessage?.length) {
      message["status message"] = (0, import_shared.buffer2hex)(this.statusMessage);
    }
    return {
      ...super.toLogEntry(),
      message
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  LearnModeIntent,
  LearnModeStatus,
  SetLearnModeCallback,
  SetLearnModeRequest,
  SetLearnModeRequestBase,
  SetLearnModeResponse
});
//# sourceMappingURL=SetLearnModeMessages.js.map
