"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ExtendedNVMOperationsMessages_exports = {};
__export(ExtendedNVMOperationsMessages_exports, {
  ExtendedNVMOperationStatus: () => ExtendedNVMOperationStatus,
  ExtendedNVMOperationsCloseRequest: () => ExtendedNVMOperationsCloseRequest,
  ExtendedNVMOperationsCommand: () => ExtendedNVMOperationsCommand,
  ExtendedNVMOperationsOpenRequest: () => ExtendedNVMOperationsOpenRequest,
  ExtendedNVMOperationsReadRequest: () => ExtendedNVMOperationsReadRequest,
  ExtendedNVMOperationsRequest: () => ExtendedNVMOperationsRequest,
  ExtendedNVMOperationsResponse: () => ExtendedNVMOperationsResponse,
  ExtendedNVMOperationsWriteRequest: () => ExtendedNVMOperationsWriteRequest
});
module.exports = __toCommonJS(ExtendedNVMOperationsMessages_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var ExtendedNVMOperationsCommand;
(function(ExtendedNVMOperationsCommand2) {
  ExtendedNVMOperationsCommand2[ExtendedNVMOperationsCommand2["Open"] = 0] = "Open";
  ExtendedNVMOperationsCommand2[ExtendedNVMOperationsCommand2["Read"] = 1] = "Read";
  ExtendedNVMOperationsCommand2[ExtendedNVMOperationsCommand2["Write"] = 2] = "Write";
  ExtendedNVMOperationsCommand2[ExtendedNVMOperationsCommand2["Close"] = 3] = "Close";
})(ExtendedNVMOperationsCommand || (ExtendedNVMOperationsCommand = {}));
var ExtendedNVMOperationStatus;
(function(ExtendedNVMOperationStatus2) {
  ExtendedNVMOperationStatus2[ExtendedNVMOperationStatus2["OK"] = 0] = "OK";
  ExtendedNVMOperationStatus2[ExtendedNVMOperationStatus2["Error"] = 1] = "Error";
  ExtendedNVMOperationStatus2[ExtendedNVMOperationStatus2["Error_OperationMismatch"] = 2] = "Error_OperationMismatch";
  ExtendedNVMOperationStatus2[ExtendedNVMOperationStatus2["Error_OperationInterference"] = 3] = "Error_OperationInterference";
  ExtendedNVMOperationStatus2[ExtendedNVMOperationStatus2["Error_SubCommandNotSupported"] = 4] = "Error_SubCommandNotSupported";
  ExtendedNVMOperationStatus2[ExtendedNVMOperationStatus2["EndOfFile"] = 255] = "EndOfFile";
})(ExtendedNVMOperationStatus || (ExtendedNVMOperationStatus = {}));
let ExtendedNVMOperationsRequest = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.ExtendedNVMOperations), (0, import_serial.priority)(import_core.MessagePriority.Controller), (0, import_serial.expectedResponse)(import_serial.FunctionType.ExtendedNVMOperations)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var ExtendedNVMOperationsRequest2 = class extends _classSuper {
    static {
      __name(this, "ExtendedNVMOperationsRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ExtendedNVMOperationsRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    // This must be set in subclasses
    command;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.command]),
        this.payload
      ]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const message = {
        command: (0, import_shared.getEnumMemberName)(ExtendedNVMOperationsCommand, this.command)
      };
      return {
        ...super.toLogEntry(),
        message
      };
    }
  };
  return ExtendedNVMOperationsRequest2 = _classThis;
})();
class ExtendedNVMOperationsOpenRequest extends ExtendedNVMOperationsRequest {
  static {
    __name(this, "ExtendedNVMOperationsOpenRequest");
  }
  constructor(options = {}) {
    super(options);
    this.command = ExtendedNVMOperationsCommand.Open;
  }
}
class ExtendedNVMOperationsCloseRequest extends ExtendedNVMOperationsRequest {
  static {
    __name(this, "ExtendedNVMOperationsCloseRequest");
  }
  constructor(options = {}) {
    super(options);
    this.command = ExtendedNVMOperationsCommand.Close;
  }
}
class ExtendedNVMOperationsReadRequest extends ExtendedNVMOperationsRequest {
  static {
    __name(this, "ExtendedNVMOperationsReadRequest");
  }
  constructor(options) {
    super(options);
    this.command = ExtendedNVMOperationsCommand.Read;
    if (options.length < 0 || options.length > 255) {
      throw new import_core.ZWaveError("The length must be between 0 and 255!", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    if (options.offset < 0 || options.offset > 4294967295) {
      throw new import_core.ZWaveError("The offset must be a 32-bit number!", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    this.length = options.length;
    this.offset = options.offset;
  }
  static from(_raw, _ctx) {
    throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
  }
  length;
  offset;
  serialize(ctx) {
    this.payload = new import_shared.Bytes(5);
    this.payload[0] = this.length;
    this.payload.writeUInt32BE(this.offset, 1);
    return super.serialize(ctx);
  }
  toLogEntry() {
    const ret = super.toLogEntry();
    return {
      ...ret,
      message: {
        ...ret.message,
        "data length": this.length,
        "address offset": (0, import_shared.num2hex)(this.offset)
      }
    };
  }
}
class ExtendedNVMOperationsWriteRequest extends ExtendedNVMOperationsRequest {
  static {
    __name(this, "ExtendedNVMOperationsWriteRequest");
  }
  constructor(options) {
    super(options);
    this.command = ExtendedNVMOperationsCommand.Write;
    if (options.offset < 0 || options.offset > 4294967295) {
      throw new import_core.ZWaveError("The offset must be a 32-bit number!", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    if (options.buffer.length < 1 || options.buffer.length > 255) {
      throw new import_core.ZWaveError("The buffer must be between 1 and 255 bytes long", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    this.offset = options.offset;
    this.buffer = options.buffer;
  }
  static from(_raw, _ctx) {
    throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
  }
  offset;
  buffer;
  serialize(ctx) {
    this.payload = new import_shared.Bytes(1 + 4 + this.buffer.length);
    this.payload[0] = this.buffer.length;
    this.payload.writeUInt32BE(this.offset, 1);
    this.payload.set(this.buffer, 5);
    return super.serialize(ctx);
  }
  toLogEntry() {
    const ret = super.toLogEntry();
    return {
      ...ret,
      message: {
        ...ret.message,
        offset: (0, import_shared.num2hex)(this.offset),
        buffer: `(${this.buffer.length} byte${this.buffer.length === 1 ? "" : "s"})`
      }
    };
  }
}
let ExtendedNVMOperationsResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.ExtendedNVMOperations)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var ExtendedNVMOperationsResponse2 = class extends _classSuper {
    static {
      __name(this, "ExtendedNVMOperationsResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ExtendedNVMOperationsResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.status = options.status;
      this.offsetOrSize = options.offsetOrSize;
      this.bufferOrBitmask = options.bufferOrBitmask;
    }
    static from(raw, _ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const status = raw.payload[0];
      const dataLength = raw.payload[1];
      let offset = 2;
      let offsetOrSize = 0;
      if (raw.payload.length >= offset + 4) {
        offsetOrSize = raw.payload.readUInt32BE(offset);
      }
      offset += 4;
      let bufferOrBitmask;
      if (dataLength > 0 && raw.payload.length >= offset + dataLength) {
        bufferOrBitmask = raw.payload.subarray(offset, offset + dataLength);
      } else {
        bufferOrBitmask = new Uint8Array();
      }
      return new this({
        status,
        offsetOrSize,
        bufferOrBitmask
      });
    }
    isOK() {
      return this.status === ExtendedNVMOperationStatus.OK || this.status === ExtendedNVMOperationStatus.EndOfFile;
    }
    status;
    offsetOrSize;
    bufferOrBitmask;
    toLogEntry() {
      const message = {
        status: (0, import_shared.getEnumMemberName)(ExtendedNVMOperationStatus, this.status),
        "address offset / NVM size": (0, import_shared.num2hex)(this.offsetOrSize)
      };
      if (this.bufferOrBitmask.length > 0) {
        message.buffer = `(${this.bufferOrBitmask.length} byte${this.bufferOrBitmask.length === 1 ? "" : "s"})`;
      }
      return {
        ...super.toLogEntry(),
        message
      };
    }
  };
  return ExtendedNVMOperationsResponse2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ExtendedNVMOperationStatus,
  ExtendedNVMOperationsCloseRequest,
  ExtendedNVMOperationsCommand,
  ExtendedNVMOperationsOpenRequest,
  ExtendedNVMOperationsReadRequest,
  ExtendedNVMOperationsRequest,
  ExtendedNVMOperationsResponse,
  ExtendedNVMOperationsWriteRequest
});
//# sourceMappingURL=ExtendedNVMOperationsMessages.js.map
