"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var FirmwareUpdateNVMMessages_exports = {};
__export(FirmwareUpdateNVMMessages_exports, {
  FirmwareUpdateNVMCommand: () => FirmwareUpdateNVMCommand,
  FirmwareUpdateNVMRequest: () => FirmwareUpdateNVMRequest,
  FirmwareUpdateNVMResponse: () => FirmwareUpdateNVMResponse,
  FirmwareUpdateNVM_GetNewImageRequest: () => FirmwareUpdateNVM_GetNewImageRequest,
  FirmwareUpdateNVM_GetNewImageResponse: () => FirmwareUpdateNVM_GetNewImageResponse,
  FirmwareUpdateNVM_InitRequest: () => FirmwareUpdateNVM_InitRequest,
  FirmwareUpdateNVM_InitResponse: () => FirmwareUpdateNVM_InitResponse,
  FirmwareUpdateNVM_IsValidCRC16Request: () => FirmwareUpdateNVM_IsValidCRC16Request,
  FirmwareUpdateNVM_IsValidCRC16Response: () => FirmwareUpdateNVM_IsValidCRC16Response,
  FirmwareUpdateNVM_SetNewImageRequest: () => FirmwareUpdateNVM_SetNewImageRequest,
  FirmwareUpdateNVM_SetNewImageResponse: () => FirmwareUpdateNVM_SetNewImageResponse,
  FirmwareUpdateNVM_UpdateCRC16Request: () => FirmwareUpdateNVM_UpdateCRC16Request,
  FirmwareUpdateNVM_UpdateCRC16Response: () => FirmwareUpdateNVM_UpdateCRC16Response,
  FirmwareUpdateNVM_WriteRequest: () => FirmwareUpdateNVM_WriteRequest,
  FirmwareUpdateNVM_WriteResponse: () => FirmwareUpdateNVM_WriteResponse
});
module.exports = __toCommonJS(FirmwareUpdateNVMMessages_exports);
var import_core = require("@zwave-js/core");
var import_reflection = require("@zwave-js/core/reflection");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var FirmwareUpdateNVMCommand;
(function(FirmwareUpdateNVMCommand2) {
  FirmwareUpdateNVMCommand2[FirmwareUpdateNVMCommand2["Init"] = 0] = "Init";
  FirmwareUpdateNVMCommand2[FirmwareUpdateNVMCommand2["SetNewImage"] = 1] = "SetNewImage";
  FirmwareUpdateNVMCommand2[FirmwareUpdateNVMCommand2["GetNewImage"] = 2] = "GetNewImage";
  FirmwareUpdateNVMCommand2[FirmwareUpdateNVMCommand2["UpdateCRC16"] = 3] = "UpdateCRC16";
  FirmwareUpdateNVMCommand2[FirmwareUpdateNVMCommand2["IsValidCRC16"] = 4] = "IsValidCRC16";
  FirmwareUpdateNVMCommand2[FirmwareUpdateNVMCommand2["Write"] = 5] = "Write";
})(FirmwareUpdateNVMCommand || (FirmwareUpdateNVMCommand = {}));
const { decorator: subCommandRequest, lookupConstructor: getSubCommandRequestConstructor, lookupValue: getSubCommandForRequest } = (0, import_reflection.createSimpleReflectionDecorator)({
  name: "subCommandRequest"
});
const { decorator: subCommandResponse, lookupConstructor: getSubCommandResponseConstructor, lookupValue: getSubCommandForResponse } = (0, import_reflection.createSimpleReflectionDecorator)({
  name: "subCommandResponse"
});
function testResponseForFirmwareUpdateNVMRequest(sent, received) {
  if (!(received instanceof FirmwareUpdateNVMResponse))
    return false;
  return sent.command === received.command;
}
__name(testResponseForFirmwareUpdateNVMRequest, "testResponseForFirmwareUpdateNVMRequest");
let FirmwareUpdateNVMRequest = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.FirmwareUpdateNVM), (0, import_serial.priority)(import_core.MessagePriority.Controller), (0, import_serial.expectedResponse)(testResponseForFirmwareUpdateNVMRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var FirmwareUpdateNVMRequest2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVMRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVMRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options = {}) {
      super(options);
      this.command = options.command ?? getSubCommandForRequest(this);
    }
    static from(raw, ctx) {
      const command = raw.payload[0];
      const payload = raw.payload.subarray(1);
      const CommandConstructor = getSubCommandRequestConstructor(command);
      if (CommandConstructor) {
        return CommandConstructor.from(raw.withPayload(payload), ctx);
      }
      const ret = new FirmwareUpdateNVMRequest2({
        command
      });
      ret.payload = payload;
      return ret;
    }
    command;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.command]),
        this.payload
      ]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const message = {
        command: (0, import_shared.getEnumMemberName)(FirmwareUpdateNVMCommand, this.command)
      };
      if (this.payload.length > 0) {
        message.payload = `0x${this.payload.toString("hex")}`;
      }
      return {
        ...super.toLogEntry(),
        message
      };
    }
  };
  return FirmwareUpdateNVMRequest2 = _classThis;
})();
let FirmwareUpdateNVMResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.FirmwareUpdateNVM)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var FirmwareUpdateNVMResponse2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVMResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVMResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.command = options.command ?? getSubCommandForResponse(this);
    }
    static from(raw, ctx) {
      const command = raw.payload[0];
      const payload = raw.payload.subarray(1);
      const CommandConstructor = getSubCommandResponseConstructor(command);
      if (CommandConstructor) {
        return CommandConstructor.from(raw.withPayload(payload), ctx);
      }
      const ret = new FirmwareUpdateNVMResponse2({
        command
      });
      ret.payload = payload;
      return ret;
    }
    command;
    toLogEntry() {
      const message = {
        command: (0, import_shared.getEnumMemberName)(FirmwareUpdateNVMCommand, this.command)
      };
      if (this.payload.length > 0) {
        message.payload = `0x${this.payload.toString("hex")}`;
      }
      return {
        ...super.toLogEntry(),
        message
      };
    }
  };
  return FirmwareUpdateNVMResponse2 = _classThis;
})();
let FirmwareUpdateNVM_InitRequest = (() => {
  let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.Init)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMRequest;
  var FirmwareUpdateNVM_InitRequest2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_InitRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_InitRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return FirmwareUpdateNVM_InitRequest2 = _classThis;
})();
let FirmwareUpdateNVM_InitResponse = (() => {
  let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.Init)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMResponse;
  var FirmwareUpdateNVM_InitResponse2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_InitResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_InitResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supported = options.supported;
    }
    static from(raw, _ctx) {
      const supported = raw.payload[0] !== 0;
      return new this({
        supported
      });
    }
    supported;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message["FW update supported"] = this.supported;
      delete message.payload;
      return ret;
    }
  };
  return FirmwareUpdateNVM_InitResponse2 = _classThis;
})();
let FirmwareUpdateNVM_SetNewImageRequest = (() => {
  let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.SetNewImage)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMRequest;
  var FirmwareUpdateNVM_SetNewImageRequest2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_SetNewImageRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_SetNewImageRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.newImage = options.newImage;
    }
    static from(raw, _ctx) {
      const newImage = raw.payload[0] !== 0;
      return new this({
        newImage
      });
    }
    newImage;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.newImage ? 1 : 0]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message["new image"] = this.newImage;
      delete message.payload;
      return ret;
    }
  };
  return FirmwareUpdateNVM_SetNewImageRequest2 = _classThis;
})();
let FirmwareUpdateNVM_SetNewImageResponse = (() => {
  let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.SetNewImage)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMResponse;
  var FirmwareUpdateNVM_SetNewImageResponse2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_SetNewImageResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_SetNewImageResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.changed = options.changed;
    }
    static from(raw, _ctx) {
      const changed = raw.payload[0] !== 0;
      return new this({
        changed
      });
    }
    changed;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.changed = this.changed;
      delete message.payload;
      return ret;
    }
  };
  return FirmwareUpdateNVM_SetNewImageResponse2 = _classThis;
})();
let FirmwareUpdateNVM_GetNewImageRequest = (() => {
  let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.GetNewImage)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMRequest;
  var FirmwareUpdateNVM_GetNewImageRequest2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_GetNewImageRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_GetNewImageRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return FirmwareUpdateNVM_GetNewImageRequest2 = _classThis;
})();
let FirmwareUpdateNVM_GetNewImageResponse = (() => {
  let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.GetNewImage)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMResponse;
  var FirmwareUpdateNVM_GetNewImageResponse2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_GetNewImageResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_GetNewImageResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.newImage = options.newImage;
    }
    static from(raw, _ctx) {
      const newImage = raw.payload[0] !== 0;
      return new this({
        newImage
      });
    }
    newImage;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message["new image"] = this.newImage;
      delete message.payload;
      return ret;
    }
  };
  return FirmwareUpdateNVM_GetNewImageResponse2 = _classThis;
})();
let FirmwareUpdateNVM_UpdateCRC16Request = (() => {
  let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.UpdateCRC16)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMRequest;
  var FirmwareUpdateNVM_UpdateCRC16Request2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_UpdateCRC16Request");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_UpdateCRC16Request2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.command = FirmwareUpdateNVMCommand.UpdateCRC16;
      this.crcSeed = options.crcSeed;
      this.offset = options.offset;
      this.blockLength = options.blockLength;
    }
    static from(raw, _ctx) {
      const offset = raw.payload.readUIntBE(0, 3);
      const blockLength = raw.payload.readUInt16BE(3);
      const crcSeed = raw.payload.readUInt16BE(5);
      return new this({
        crcSeed,
        offset,
        blockLength
      });
    }
    crcSeed;
    offset;
    blockLength;
    getResponseTimeout() {
      return 3e4;
    }
    serialize(ctx) {
      this.payload = new import_shared.Bytes(7);
      this.payload.writeUIntBE(this.offset, 0, 3);
      this.payload.writeUInt16BE(this.blockLength, 3);
      this.payload.writeUInt16BE(this.crcSeed, 5);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.offset = (0, import_shared.num2hex)(this.offset);
      message["block length"] = this.blockLength;
      message["CRC seed"] = (0, import_shared.num2hex)(this.crcSeed);
      delete message.payload;
      return ret;
    }
  };
  return FirmwareUpdateNVM_UpdateCRC16Request2 = _classThis;
})();
let FirmwareUpdateNVM_UpdateCRC16Response = (() => {
  let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.UpdateCRC16)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMResponse;
  var FirmwareUpdateNVM_UpdateCRC16Response2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_UpdateCRC16Response");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_UpdateCRC16Response2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.crc16 = options.crc16;
    }
    static from(raw, _ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const crc16 = raw.payload.readUInt16BE(0);
      return new this({
        crc16
      });
    }
    crc16;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message["CRC-16"] = (0, import_shared.num2hex)(this.crc16);
      delete message.payload;
      return ret;
    }
  };
  return FirmwareUpdateNVM_UpdateCRC16Response2 = _classThis;
})();
let FirmwareUpdateNVM_IsValidCRC16Request = (() => {
  let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.IsValidCRC16)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMRequest;
  var FirmwareUpdateNVM_IsValidCRC16Request2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_IsValidCRC16Request");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_IsValidCRC16Request2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    getResponseTimeout() {
      return 3e4;
    }
  };
  return FirmwareUpdateNVM_IsValidCRC16Request2 = _classThis;
})();
let FirmwareUpdateNVM_IsValidCRC16Response = (() => {
  let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.IsValidCRC16)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMResponse;
  var FirmwareUpdateNVM_IsValidCRC16Response2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_IsValidCRC16Response");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_IsValidCRC16Response2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.isValid = options.isValid;
    }
    static from(raw, _ctx) {
      const isValid = raw.payload[0] !== 0;
      return new this({
        isValid
      });
    }
    isValid;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message["CRC-16 valid"] = this.isValid;
      delete message.payload;
      return ret;
    }
  };
  return FirmwareUpdateNVM_IsValidCRC16Response2 = _classThis;
})();
let FirmwareUpdateNVM_WriteRequest = (() => {
  let _classDecorators = [subCommandRequest(FirmwareUpdateNVMCommand.Write)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMRequest;
  var FirmwareUpdateNVM_WriteRequest2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_WriteRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_WriteRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.offset = options.offset;
      this.buffer = options.buffer;
    }
    static from(raw, _ctx) {
      const offset = raw.payload.readUIntBE(0, 3);
      const bufferLength = raw.payload.readUInt16BE(3);
      const buffer = raw.payload.subarray(5, 5 + bufferLength);
      return new this({
        offset,
        buffer
      });
    }
    offset;
    buffer;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(5 + this.buffer.length);
      this.payload.writeUIntBE(this.offset, 0, 3);
      this.payload.writeUInt16BE(this.buffer.length, 3);
      this.payload.set(this.buffer, 5);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.offset = (0, import_shared.num2hex)(this.offset);
      if (this.buffer.length > 0) {
        message.buffer = `(${this.buffer.length} byte${this.buffer.length === 1 ? "" : "s"})`;
      }
      delete message.payload;
      return ret;
    }
  };
  return FirmwareUpdateNVM_WriteRequest2 = _classThis;
})();
let FirmwareUpdateNVM_WriteResponse = (() => {
  let _classDecorators = [subCommandResponse(FirmwareUpdateNVMCommand.Write)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = FirmwareUpdateNVMResponse;
  var FirmwareUpdateNVM_WriteResponse2 = class extends _classSuper {
    static {
      __name(this, "FirmwareUpdateNVM_WriteResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      FirmwareUpdateNVM_WriteResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.overwritten = options.overwritten;
    }
    static from(raw, _ctx) {
      const overwritten = raw.payload[0] !== 0;
      return new this({
        overwritten
      });
    }
    overwritten;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.overwritten = this.overwritten;
      delete message.payload;
      return ret;
    }
  };
  return FirmwareUpdateNVM_WriteResponse2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  FirmwareUpdateNVMCommand,
  FirmwareUpdateNVMRequest,
  FirmwareUpdateNVMResponse,
  FirmwareUpdateNVM_GetNewImageRequest,
  FirmwareUpdateNVM_GetNewImageResponse,
  FirmwareUpdateNVM_InitRequest,
  FirmwareUpdateNVM_InitResponse,
  FirmwareUpdateNVM_IsValidCRC16Request,
  FirmwareUpdateNVM_IsValidCRC16Response,
  FirmwareUpdateNVM_SetNewImageRequest,
  FirmwareUpdateNVM_SetNewImageResponse,
  FirmwareUpdateNVM_UpdateCRC16Request,
  FirmwareUpdateNVM_UpdateCRC16Response,
  FirmwareUpdateNVM_WriteRequest,
  FirmwareUpdateNVM_WriteResponse
});
//# sourceMappingURL=FirmwareUpdateNVMMessages.js.map
