"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZnifferSerialStream_exports = {};
__export(ZnifferSerialStream_exports, {
  ZnifferSerialStream: () => ZnifferSerialStream,
  ZnifferSerialStreamFactory: () => ZnifferSerialStreamFactory
});
module.exports = __toCommonJS(ZnifferSerialStream_exports);
var import_shared = require("@zwave-js/shared");
var import_Logger = require("../log/Logger.js");
var import_ZnifferParser = require("../parsers/ZnifferParser.js");
class ZnifferSerialStreamFactory {
  static {
    __name(this, "ZnifferSerialStreamFactory");
  }
  constructor(binding, loggers) {
    this.binding = binding;
    this.logger = new import_Logger.SerialLogger(loggers);
  }
  binding;
  logger;
  async createStream() {
    const { source, sink } = await this.binding();
    return new ZnifferSerialStream(source, sink, this.logger);
  }
}
class ZnifferSerialStream {
  static {
    __name(this, "ZnifferSerialStream");
  }
  constructor(source, sink, logger) {
    this.logger = logger;
    this.#abort = new AbortController();
    const { readable: input, writable } = new TransformStream();
    this.writable = writable;
    const sinkStream = new WritableStream(sink);
    void input.pipeTo(sinkStream, { signal: this.#abort.signal }).catch(import_shared.noop);
    const { readable, writable: output } = new TransformStream();
    this.readable = readable;
    const parser = new import_ZnifferParser.ZnifferParser(logger);
    const sourceStream = new ReadableStream(source);
    void sourceStream.pipeThrough(parser, { signal: this.#abort.signal }).pipeTo(output, { signal: this.#abort.signal }).catch((_e) => {
      this._isOpen = false;
    });
  }
  logger;
  // Public interface to let consumers read from and write to this stream
  readable;
  writable;
  // Signal to close the underlying stream
  #abort;
  async close() {
    this._isOpen = false;
    if (this._writer) {
      try {
        this._writer?.releaseLock();
        this._writer = void 0;
        await this.writable.close();
      } catch {
      }
    }
    this.#abort.abort();
    return Promise.resolve();
  }
  _isOpen = true;
  get isOpen() {
    return this._isOpen;
  }
  _writer;
  async writeAsync(data) {
    if (!this.isOpen) {
      throw new Error("The serial port is not open!");
    }
    this.logger.data("outbound", data);
    this._writer ??= this.writable.getWriter();
    await this._writer.write(data);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZnifferSerialStream,
  ZnifferSerialStreamFactory
});
//# sourceMappingURL=ZnifferSerialStream.js.map
