var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { ZWaveError, ZWaveErrorCodes } from "@zwave-js/core";
import { Bytes } from "@zwave-js/shared";
import { ESPHomeMessage, ESPHomeMessageType, messageType, } from "./ESPHomeMessage.js";
import { decodeStringField, decodeVarInt, encodeStringField, encodeVarintField, parseProtobufMessage, skipField, } from "./ProtobufHelpers.js";
let DeviceInfoRequest = (() => {
    let _classDecorators = [messageType(ESPHomeMessageType.DeviceInfoRequest)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ESPHomeMessage;
    var DeviceInfoRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            DeviceInfoRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return DeviceInfoRequest = _classThis;
})();
export { DeviceInfoRequest };
let DeviceInfoResponse = (() => {
    let _classDecorators = [messageType(ESPHomeMessageType.DeviceInfoResponse)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ESPHomeMessage;
    var DeviceInfoResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            DeviceInfoResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.usesPassword = options.usesPassword ?? false;
            this.name = options.name ?? "";
            this.macAddress = options.macAddress ?? "";
            this.esphomeVersion = options.esphomeVersion ?? "";
            this.compilationTime = options.compilationTime ?? "";
            this.model = options.model ?? "";
            this.hasDeepSleep = options.hasDeepSleep ?? false;
            this.projectName = options.projectName ?? "";
            this.projectVersion = options.projectVersion ?? "";
            this.webserverPort = options.webserverPort ?? 0;
            this.manufacturer = options.manufacturer ?? "";
            this.friendlyName = options.friendlyName ?? "";
            this.suggestedArea = options.suggestedArea ?? "";
            this.bluetoothMacAddress = options.bluetoothMacAddress ?? "";
            this.apiEncryptionSupported = options.apiEncryptionSupported ?? false;
            this.zwaveProxyFeatureFlags = options.zwaveProxyFeatureFlags ?? 0;
        }
        static from(raw) {
            let usesPassword = false;
            let name = "";
            let macAddress = "";
            let esphomeVersion = "";
            let compilationTime = "";
            let model = "";
            let hasDeepSleep = false;
            let projectName = "";
            let projectVersion = "";
            let webserverPort = 0;
            let manufacturer = "";
            let friendlyName = "";
            let suggestedArea = "";
            let bluetoothMacAddress = "";
            let apiEncryptionSupported = false;
            let zwaveProxyFeatureFlags = 0;
            parseProtobufMessage(raw.payload, (fieldNumber, wireType, data, offset) => {
                switch (fieldNumber) {
                    case 1: // uses_password (bool)
                        if (wireType !== 0 /* WireType.Varint */) {
                            throw new ZWaveError("Invalid wire type for usesPassword", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const usesPasswordResult = decodeVarInt(data, offset);
                        usesPassword = usesPasswordResult.value !== 0;
                        return offset + usesPasswordResult.bytesRead;
                    case 2: // name (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for name", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const nameResult = decodeStringField(data, offset);
                        name = nameResult.value;
                        return offset + nameResult.bytesRead;
                    case 3: // mac_address (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for macAddress", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const macAddressResult = decodeStringField(data, offset);
                        macAddress = macAddressResult.value;
                        return offset + macAddressResult.bytesRead;
                    case 4: // esphome_version (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for esphomeVersion", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const esphomeVersionResult = decodeStringField(data, offset);
                        esphomeVersion = esphomeVersionResult.value;
                        return offset + esphomeVersionResult.bytesRead;
                    case 5: // compilation_time (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for compilationTime", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const compilationTimeResult = decodeStringField(data, offset);
                        compilationTime = compilationTimeResult.value;
                        return offset + compilationTimeResult.bytesRead;
                    case 6: // model (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for model", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const modelResult = decodeStringField(data, offset);
                        model = modelResult.value;
                        return offset + modelResult.bytesRead;
                    case 7: // has_deep_sleep (bool)
                        if (wireType !== 0 /* WireType.Varint */) {
                            throw new ZWaveError("Invalid wire type for hasDeepSleep", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const hasDeepSleepResult = decodeVarInt(data, offset);
                        hasDeepSleep = hasDeepSleepResult.value !== 0;
                        return offset + hasDeepSleepResult.bytesRead;
                    case 8: // project_name (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for projectName", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const projectNameResult = decodeStringField(data, offset);
                        projectName = projectNameResult.value;
                        return offset + projectNameResult.bytesRead;
                    case 9: // project_version (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for projectVersion", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const projectVersionResult = decodeStringField(data, offset);
                        projectVersion = projectVersionResult.value;
                        return offset + projectVersionResult.bytesRead;
                    case 10: // webserver_port (uint32)
                        if (wireType !== 0 /* WireType.Varint */) {
                            throw new ZWaveError("Invalid wire type for webserverPort", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const webserverPortResult = decodeVarInt(data, offset);
                        webserverPort = webserverPortResult.value;
                        return offset + webserverPortResult.bytesRead;
                    case 12: // manufacturer (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for manufacturer", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const manufacturerResult = decodeStringField(data, offset);
                        manufacturer = manufacturerResult.value;
                        return offset + manufacturerResult.bytesRead;
                    case 13: // friendly_name (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for friendlyName", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const friendlyNameResult = decodeStringField(data, offset);
                        friendlyName = friendlyNameResult.value;
                        return offset + friendlyNameResult.bytesRead;
                    case 16: // suggested_area (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for suggestedArea", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const suggestedAreaResult = decodeStringField(data, offset);
                        suggestedArea = suggestedAreaResult.value;
                        return offset + suggestedAreaResult.bytesRead;
                    case 18: // bluetooth_mac_address (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for bluetoothMacAddress", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const bluetoothMacAddressResult = decodeStringField(data, offset);
                        bluetoothMacAddress = bluetoothMacAddressResult.value;
                        return offset + bluetoothMacAddressResult.bytesRead;
                    case 19: // api_encryption_supported (bool)
                        if (wireType !== 0 /* WireType.Varint */) {
                            throw new ZWaveError("Invalid wire type for apiEncryptionSupported", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const apiEncryptionSupportedResult = decodeVarInt(data, offset);
                        apiEncryptionSupported =
                            apiEncryptionSupportedResult.value !== 0;
                        return offset + apiEncryptionSupportedResult.bytesRead;
                    case 23: // zwave_proxy_feature_flags (uint32)
                        if (wireType !== 0 /* WireType.Varint */) {
                            throw new ZWaveError("Invalid wire type for zwaveProxyFeatureFlags", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const zwaveProxyFeatureFlagsResult = decodeVarInt(data, offset);
                        zwaveProxyFeatureFlags =
                            zwaveProxyFeatureFlagsResult.value;
                        return offset
                            + zwaveProxyFeatureFlagsResult.bytesRead;
                    default:
                        return skipField(data, offset, wireType);
                }
            });
            return new this({
                usesPassword,
                name,
                macAddress,
                esphomeVersion,
                compilationTime,
                model,
                hasDeepSleep,
                projectName,
                projectVersion,
                webserverPort,
                manufacturer,
                friendlyName,
                suggestedArea,
                bluetoothMacAddress,
                apiEncryptionSupported,
                zwaveProxyFeatureFlags,
            });
        }
        usesPassword;
        name;
        macAddress;
        esphomeVersion;
        compilationTime;
        model;
        hasDeepSleep;
        projectName;
        projectVersion;
        webserverPort;
        manufacturer;
        friendlyName;
        suggestedArea;
        bluetoothMacAddress;
        apiEncryptionSupported;
        zwaveProxyFeatureFlags;
        /**
         * Check if Z-Wave proxy support is available
         */
        get hasZWaveProxySupport() {
            return this.zwaveProxyFeatureFlags > 0;
        }
        serialize() {
            const parts = [];
            // Field 1: uses_password (bool)
            if (this.usesPassword) {
                parts.push(encodeVarintField(1, 1));
            }
            // Field 2: name (string)
            if (this.name) {
                parts.push(encodeStringField(2, this.name));
            }
            // Field 3: mac_address (string)
            if (this.macAddress) {
                parts.push(encodeStringField(3, this.macAddress));
            }
            // Field 4: esphome_version (string)
            if (this.esphomeVersion) {
                parts.push(encodeStringField(4, this.esphomeVersion));
            }
            // Field 5: compilation_time (string)
            if (this.compilationTime) {
                parts.push(encodeStringField(5, this.compilationTime));
            }
            // Field 6: model (string)
            if (this.model) {
                parts.push(encodeStringField(6, this.model));
            }
            // Field 7: has_deep_sleep (bool)
            if (this.hasDeepSleep) {
                parts.push(encodeVarintField(7, 1));
            }
            // Field 8: project_name (string)
            if (this.projectName) {
                parts.push(encodeStringField(8, this.projectName));
            }
            // Field 9: project_version (string)
            if (this.projectVersion) {
                parts.push(encodeStringField(9, this.projectVersion));
            }
            // Field 10: webserver_port (uint32)
            if (this.webserverPort > 0) {
                parts.push(encodeVarintField(10, this.webserverPort));
            }
            // Field 12: manufacturer (string)
            if (this.manufacturer) {
                parts.push(encodeStringField(12, this.manufacturer));
            }
            // Field 13: friendly_name (string)
            if (this.friendlyName) {
                parts.push(encodeStringField(13, this.friendlyName));
            }
            // Field 16: suggested_area (string)
            if (this.suggestedArea) {
                parts.push(encodeStringField(16, this.suggestedArea));
            }
            // Field 18: bluetooth_mac_address (string)
            if (this.bluetoothMacAddress) {
                parts.push(encodeStringField(18, this.bluetoothMacAddress));
            }
            // Field 19: api_encryption_supported (bool)
            if (this.apiEncryptionSupported) {
                parts.push(encodeVarintField(19, 1));
            }
            // Field 23: zwave_proxy_feature_flags (uint32)
            if (this.zwaveProxyFeatureFlags > 0) {
                parts.push(encodeVarintField(23, this.zwaveProxyFeatureFlags));
            }
            this.payload = Bytes.concat(parts);
            return super.serialize();
        }
    };
    return DeviceInfoResponse = _classThis;
})();
export { DeviceInfoResponse };
//# sourceMappingURL=DeviceInfoMessages.js.map