import { Bytes } from "@zwave-js/shared";
import { ESPHomeMessage, type ESPHomeMessageBaseOptions, type ESPHomeMessageRaw } from "./ESPHomeMessage.js";
export interface HelloRequestOptions extends ESPHomeMessageBaseOptions {
    clientInfo: string;
    apiVersionMajor: number;
    apiVersionMinor: number;
}
export declare class HelloRequest extends ESPHomeMessage {
    constructor(options: HelloRequestOptions);
    static from(raw: ESPHomeMessageRaw): HelloRequest;
    clientInfo: string;
    apiVersionMajor: number;
    apiVersionMinor: number;
    serialize(): Bytes;
}
export interface HelloResponseOptions extends ESPHomeMessageBaseOptions {
    apiVersionMajor: number;
    apiVersionMinor: number;
    serverInfo: string;
    name: string;
}
export declare class HelloResponse extends ESPHomeMessage {
    constructor(options: HelloResponseOptions);
    static from(raw: ESPHomeMessageRaw): HelloResponse;
    apiVersionMajor: number;
    apiVersionMinor: number;
    serverInfo: string;
    name: string;
    serialize(): Bytes;
}
//# sourceMappingURL=HelloMessages.d.ts.map