var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { ZWaveError, ZWaveErrorCodes } from "@zwave-js/core";
import { Bytes } from "@zwave-js/shared";
import { ESPHomeMessage, ESPHomeMessageType, messageType, } from "./ESPHomeMessage.js";
import { decodeStringField, decodeVarInt, encodeStringField, encodeVarintField, parseProtobufMessage, skipField, } from "./ProtobufHelpers.js";
let HelloRequest = (() => {
    let _classDecorators = [messageType(ESPHomeMessageType.HelloRequest)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ESPHomeMessage;
    var HelloRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            HelloRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.clientInfo = options.clientInfo;
            this.apiVersionMajor = options.apiVersionMajor;
            this.apiVersionMinor = options.apiVersionMinor;
        }
        static from(raw) {
            let clientInfo = "";
            let apiVersionMajor = 0;
            let apiVersionMinor = 0;
            parseProtobufMessage(raw.payload, (fieldNumber, wireType, data, offset) => {
                switch (fieldNumber) {
                    case 1: // client_info (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for clientInfo", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const clientInfoResult = decodeStringField(data, offset);
                        clientInfo = clientInfoResult.value;
                        return offset + clientInfoResult.bytesRead;
                    case 2: // api_version_major (uint32)
                        if (wireType !== 0 /* WireType.Varint */) {
                            throw new ZWaveError("Invalid wire type for apiVersionMajor", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const majorResult = decodeVarInt(data, offset);
                        apiVersionMajor = majorResult.value;
                        return offset + majorResult.bytesRead;
                    case 3: // api_version_minor (uint32)
                        if (wireType !== 0 /* WireType.Varint */) {
                            throw new ZWaveError("Invalid wire type for apiVersionMinor", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const minorResult = decodeVarInt(data, offset);
                        apiVersionMinor = minorResult.value;
                        return offset + minorResult.bytesRead;
                    default:
                        return skipField(data, offset, wireType);
                }
            });
            return new this({
                clientInfo,
                apiVersionMajor,
                apiVersionMinor,
            });
        }
        clientInfo;
        apiVersionMajor;
        apiVersionMinor;
        serialize() {
            const parts = [];
            // Field 1: client_info (string)
            if (this.clientInfo) {
                parts.push(encodeStringField(1, this.clientInfo));
            }
            // Field 2: api_version_major (uint32)
            parts.push(encodeVarintField(2, this.apiVersionMajor));
            // Field 3: api_version_minor (uint32)
            parts.push(encodeVarintField(3, this.apiVersionMinor));
            this.payload = Bytes.concat(parts);
            return super.serialize();
        }
    };
    return HelloRequest = _classThis;
})();
export { HelloRequest };
let HelloResponse = (() => {
    let _classDecorators = [messageType(ESPHomeMessageType.HelloResponse)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ESPHomeMessage;
    var HelloResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            HelloResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.apiVersionMajor = options.apiVersionMajor;
            this.apiVersionMinor = options.apiVersionMinor;
            this.serverInfo = options.serverInfo;
            this.name = options.name;
        }
        static from(raw) {
            let apiVersionMajor = 0;
            let apiVersionMinor = 0;
            let serverInfo = "";
            let name = "";
            parseProtobufMessage(raw.payload, (fieldNumber, wireType, data, offset) => {
                switch (fieldNumber) {
                    case 1: // api_version_major (uint32)
                        if (wireType !== 0 /* WireType.Varint */) {
                            throw new ZWaveError("Invalid wire type for apiVersionMajor", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const majorResult = decodeVarInt(data, offset);
                        apiVersionMajor = majorResult.value;
                        return offset + majorResult.bytesRead;
                    case 2: // api_version_minor (uint32)
                        if (wireType !== 0 /* WireType.Varint */) {
                            throw new ZWaveError("Invalid wire type for apiVersionMinor", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const minorResult = decodeVarInt(data, offset);
                        apiVersionMinor = minorResult.value;
                        return offset + minorResult.bytesRead;
                    case 3: // server_info (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for serverInfo", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const serverInfoResult = decodeStringField(data, offset);
                        serverInfo = serverInfoResult.value;
                        return offset + serverInfoResult.bytesRead;
                    case 4: // name (string)
                        if (wireType !== 2 /* WireType.LengthDelimited */) {
                            throw new ZWaveError("Invalid wire type for name", ZWaveErrorCodes.Argument_Invalid);
                        }
                        const nameResult = decodeStringField(data, offset);
                        name = nameResult.value;
                        return offset + nameResult.bytesRead;
                    default:
                        return skipField(data, offset, wireType);
                }
            });
            return new this({
                apiVersionMajor,
                apiVersionMinor,
                serverInfo,
                name,
            });
        }
        apiVersionMajor;
        apiVersionMinor;
        serverInfo;
        name;
        serialize() {
            const parts = [];
            // Field 1: api_version_major (uint32)
            parts.push(encodeVarintField(1, this.apiVersionMajor));
            // Field 2: api_version_minor (uint32)
            parts.push(encodeVarintField(2, this.apiVersionMinor));
            // Field 3: server_info (string)
            if (this.serverInfo) {
                parts.push(encodeStringField(3, this.serverInfo));
            }
            // Field 4: name (string)
            if (this.name) {
                parts.push(encodeStringField(4, this.name));
            }
            this.payload = Bytes.concat(parts);
            return super.serialize();
        }
    };
    return HelloResponse = _classThis;
})();
export { HelloResponse };
//# sourceMappingURL=HelloMessages.js.map