var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, encodeCCList, parseCCList, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName, num2hex } from "@zwave-js/shared";
export var SerialAPIWakeUpReason;
(function (SerialAPIWakeUpReason) {
    /** The Z-Wave API Module has been woken up by reset or external interrupt. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["Reset"] = 0] = "Reset";
    /** The Z-Wave API Module has been woken up by a timer. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["WakeUpTimer"] = 1] = "WakeUpTimer";
    /** The Z-Wave API Module has been woken up by a Wake Up Beam. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["WakeUpBeam"] = 2] = "WakeUpBeam";
    /** The Z-Wave API Module has been woken up by a reset triggered by the watchdog. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["WatchdogReset"] = 3] = "WatchdogReset";
    /** The Z-Wave API Module has been woken up by an external interrupt. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["ExternalInterrupt"] = 4] = "ExternalInterrupt";
    /** The Z-Wave API Module has been woken up by powering up. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["PowerUp"] = 5] = "PowerUp";
    /** The Z-Wave API Module has been woken up by USB Suspend. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["USBSuspend"] = 6] = "USBSuspend";
    /** The Z-Wave API Module has been woken up by a reset triggered by software. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["SoftwareReset"] = 7] = "SoftwareReset";
    /** The Z-Wave API Module has been woken up by an emergency watchdog reset. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["EmergencyWatchdogReset"] = 8] = "EmergencyWatchdogReset";
    /** The Z-Wave API Module has been woken up by a reset triggered by brownout circuit. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["BrownoutCircuit"] = 9] = "BrownoutCircuit";
    /** The Z-Wave API Module has been woken up by an unknown reason. */
    SerialAPIWakeUpReason[SerialAPIWakeUpReason["Unknown"] = 255] = "Unknown";
})(SerialAPIWakeUpReason || (SerialAPIWakeUpReason = {}));
let SerialAPIStartedRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.SerialAPIStarted), priority(MessagePriority.Normal)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SerialAPIStartedRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPIStartedRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.wakeUpReason = options.wakeUpReason;
            this.watchdogEnabled = options.watchdogEnabled;
            this.isListening = options.isListening;
            this.genericDeviceClass = options.genericDeviceClass;
            this.specificDeviceClass = options.specificDeviceClass;
            this.supportedCCs = options.supportedCCs;
            this.controlledCCs = options.controlledCCs;
            this.supportsLongRange = options.supportsLongRange;
        }
        static from(raw) {
            const wakeUpReason = raw.payload[0];
            const watchdogEnabled = raw.payload[1] === 0x01;
            const deviceOption = raw.payload[2];
            const isListening = !!(deviceOption & 0b10_000_000);
            const genericDeviceClass = raw.payload[3];
            const specificDeviceClass = raw.payload[4];
            // Parse list of CCs
            const numCCBytes = raw.payload[5];
            const ccBytes = raw.payload.subarray(6, 6 + numCCBytes);
            const ccList = parseCCList(ccBytes);
            const supportedCCs = ccList.supportedCCs;
            const controlledCCs = ccList.controlledCCs;
            // Parse supported protocols
            let supportsLongRange = false;
            if (raw.payload.length >= 6 + numCCBytes + 1) {
                const protocols = raw.payload[6 + numCCBytes];
                supportsLongRange = !!(protocols & 0b1);
            }
            return new this({
                wakeUpReason,
                watchdogEnabled,
                isListening,
                genericDeviceClass,
                specificDeviceClass,
                supportedCCs,
                controlledCCs,
                supportsLongRange,
            });
        }
        wakeUpReason;
        watchdogEnabled;
        genericDeviceClass;
        specificDeviceClass;
        /** Whether this node is always listening or not */
        isListening;
        supportedCCs;
        controlledCCs;
        supportsLongRange = false;
        serialize(ctx) {
            const ccList = encodeCCList(this.supportedCCs, this.controlledCCs);
            const numCCBytes = ccList.length;
            this.payload = new Bytes(6 + numCCBytes + 1);
            this.payload[0] = this.wakeUpReason;
            this.payload[1] = this.watchdogEnabled ? 0b1 : 0;
            this.payload[2] = this.isListening ? 0b10_000_000 : 0;
            this.payload[3] = this.genericDeviceClass;
            this.payload[4] = this.specificDeviceClass;
            this.payload[5] = numCCBytes;
            this.payload.set(ccList, 6);
            this.payload[6 + numCCBytes] = this.supportsLongRange ? 0b1 : 0;
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    "wake up reason": getEnumMemberName(SerialAPIWakeUpReason, this.wakeUpReason),
                    "watchdog enabled": this.watchdogEnabled,
                    "generic device class": num2hex(this.genericDeviceClass),
                    "specific device class": num2hex(this.specificDeviceClass),
                    "always listening": this.isListening,
                    // Not sure why this information is needed here. At the very least it stretches the log
                    // "supported CCs": this.supportedCCs
                    // 	.map((cc) => `\n· ${getCCName(cc)}`)
                    // 	.join(""),
                    // "controlled CCs": this.controlledCCs
                    // 	.map((cc) => `\n· ${getCCName(cc)}`)
                    // 	.join(""),
                    "supports Long Range": this.supportsLongRange,
                },
            };
        }
    };
    return SerialAPIStartedRequest = _classThis;
})();
export { SerialAPIStartedRequest };
//# sourceMappingURL=SerialAPIStartedRequest.js.map