var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, encodeNodeID } from "@zwave-js/core";
import { FunctionType, Message, MessageOrigin, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export var ReplaceFailedNodeStartFlags;
(function (ReplaceFailedNodeStartFlags) {
    ReplaceFailedNodeStartFlags[ReplaceFailedNodeStartFlags["OK"] = 0] = "OK";
    /** The replacing process was aborted because the controller  is not the primary one */
    ReplaceFailedNodeStartFlags[ReplaceFailedNodeStartFlags["NotPrimaryController"] = 2] = "NotPrimaryController";
    /** The replacing process was aborted because no call back function is used */
    ReplaceFailedNodeStartFlags[ReplaceFailedNodeStartFlags["NoCallbackFunction"] = 4] = "NoCallbackFunction";
    /** The replacing process aborted because the node was node found */
    ReplaceFailedNodeStartFlags[ReplaceFailedNodeStartFlags["NodeNotFound"] = 8] = "NodeNotFound";
    /** The replacing process is busy */
    ReplaceFailedNodeStartFlags[ReplaceFailedNodeStartFlags["ReplaceProcessBusy"] = 16] = "ReplaceProcessBusy";
    /** The replacing process could not be started*/
    ReplaceFailedNodeStartFlags[ReplaceFailedNodeStartFlags["ReplaceFailed"] = 32] = "ReplaceFailed";
})(ReplaceFailedNodeStartFlags || (ReplaceFailedNodeStartFlags = {}));
export var ReplaceFailedNodeStatus;
(function (ReplaceFailedNodeStatus) {
    /* ZW_ReplaceFailedNode callback status definitions */
    ReplaceFailedNodeStatus[ReplaceFailedNodeStatus["NodeOK"] = 0] = "NodeOK";
    /** The failed node is ready to be replaced and controller is ready to add new node with the nodeID of the failed node. */
    ReplaceFailedNodeStatus[ReplaceFailedNodeStatus["FailedNodeReplace"] = 3] = "FailedNodeReplace";
    /** The failed node has been replaced. */
    ReplaceFailedNodeStatus[ReplaceFailedNodeStatus["FailedNodeReplaceDone"] = 4] = "FailedNodeReplaceDone";
    /** The failed node has not been replaced */
    ReplaceFailedNodeStatus[ReplaceFailedNodeStatus["FailedNodeReplaceFailed"] = 5] = "FailedNodeReplaceFailed";
})(ReplaceFailedNodeStatus || (ReplaceFailedNodeStatus = {}));
let ReplaceFailedNodeRequestBase = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.ReplaceFailedNode), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var ReplaceFailedNodeRequestBase = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ReplaceFailedNodeRequestBase = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        static from(raw, ctx) {
            if (ctx.origin === MessageOrigin.Host) {
                return ReplaceFailedNodeRequest.from(raw, ctx);
            }
            else {
                return ReplaceFailedNodeRequestStatusReport.from(raw, ctx);
            }
        }
    };
    return ReplaceFailedNodeRequestBase = _classThis;
})();
export { ReplaceFailedNodeRequestBase };
let ReplaceFailedNodeRequest = (() => {
    let _classDecorators = [expectedResponse(FunctionType.ReplaceFailedNode)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = ReplaceFailedNodeRequestBase;
    var ReplaceFailedNodeRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ReplaceFailedNodeRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.failedNodeId = options.failedNodeId;
        }
        // This must not be called nodeId or rejectAllTransactions may reject the request
        /** The node that should be removed */
        failedNodeId;
        serialize(ctx) {
            this.assertCallbackId();
            const nodeId = encodeNodeID(this.failedNodeId, ctx.nodeIdType);
            this.payload = Bytes.concat([nodeId, Bytes.from([this.callbackId])]);
            return super.serialize(ctx);
        }
    };
    return ReplaceFailedNodeRequest = _classThis;
})();
export { ReplaceFailedNodeRequest };
let ReplaceFailedNodeResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.ReplaceFailedNode)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var ReplaceFailedNodeResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ReplaceFailedNodeResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.replaceStatus = options.replaceStatus;
        }
        static from(raw, _ctx) {
            const replaceStatus = raw.payload[0];
            return new this({
                replaceStatus,
            });
        }
        replaceStatus;
        isOK() {
            return this.replaceStatus === ReplaceFailedNodeStartFlags.OK;
        }
    };
    return ReplaceFailedNodeResponse = _classThis;
})();
export { ReplaceFailedNodeResponse };
export class ReplaceFailedNodeRequestStatusReport extends ReplaceFailedNodeRequestBase {
    constructor(options) {
        super(options);
        // TODO: Check implementation:
        this.callbackId = options.callbackId;
        this.replaceStatus = options.replaceStatus;
    }
    static from(raw, _ctx) {
        const callbackId = raw.payload[0];
        const replaceStatus = raw.payload[1];
        return new this({
            callbackId,
            replaceStatus,
        });
    }
    replaceStatus;
    isOK() {
        return (this.replaceStatus
            === ReplaceFailedNodeStatus.FailedNodeReplaceDone);
    }
}
//# sourceMappingURL=ReplaceFailedNodeRequest.js.map