var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, encodeNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageOrigin, MessageType, expectedCallback, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName } from "@zwave-js/shared";
export var NodeNeighborUpdateStatus;
(function (NodeNeighborUpdateStatus) {
    NodeNeighborUpdateStatus[NodeNeighborUpdateStatus["UpdateStarted"] = 33] = "UpdateStarted";
    NodeNeighborUpdateStatus[NodeNeighborUpdateStatus["UpdateDone"] = 34] = "UpdateDone";
    NodeNeighborUpdateStatus[NodeNeighborUpdateStatus["UpdateFailed"] = 35] = "UpdateFailed";
})(NodeNeighborUpdateStatus || (NodeNeighborUpdateStatus = {}));
let RequestNodeNeighborUpdateRequestBase = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.RequestNodeNeighborUpdate), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var RequestNodeNeighborUpdateRequestBase = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            RequestNodeNeighborUpdateRequestBase = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        static from(raw, ctx) {
            if (ctx.origin === MessageOrigin.Host) {
                return RequestNodeNeighborUpdateRequest.from(raw, ctx);
            }
            else {
                return RequestNodeNeighborUpdateReport.from(raw, ctx);
            }
        }
    };
    return RequestNodeNeighborUpdateRequestBase = _classThis;
})();
export { RequestNodeNeighborUpdateRequestBase };
let RequestNodeNeighborUpdateRequest = (() => {
    let _classDecorators = [expectedCallback(FunctionType.RequestNodeNeighborUpdate)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = RequestNodeNeighborUpdateRequestBase;
    var RequestNodeNeighborUpdateRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            RequestNodeNeighborUpdateRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.nodeId = options.nodeId;
            this.discoveryTimeout = options.discoveryTimeout;
        }
        nodeId;
        discoveryTimeout;
        serialize(ctx) {
            this.assertCallbackId();
            const nodeId = encodeNodeID(this.nodeId, ctx.nodeIdType);
            this.payload = Bytes.concat([nodeId, Bytes.from([this.callbackId])]);
            return super.serialize(ctx);
        }
        getCallbackTimeout() {
            return this.discoveryTimeout;
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    "callback id": this.callbackId ?? "(not set)",
                },
            };
        }
    };
    return RequestNodeNeighborUpdateRequest = _classThis;
})();
export { RequestNodeNeighborUpdateRequest };
export class RequestNodeNeighborUpdateReport extends RequestNodeNeighborUpdateRequestBase {
    constructor(options) {
        super(options);
        this.callbackId = options.callbackId;
        this.updateStatus = options.updateStatus;
    }
    static from(raw, _ctx) {
        const callbackId = raw.payload[0];
        const updateStatus = raw.payload[1];
        return new this({
            callbackId,
            updateStatus,
        });
    }
    isOK() {
        return this.updateStatus !== NodeNeighborUpdateStatus.UpdateFailed;
    }
    isFinal() {
        return this.updateStatus === NodeNeighborUpdateStatus.UpdateDone;
    }
    updateStatus;
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId ?? "(not set)",
                "update status": getEnumMemberName(NodeNeighborUpdateStatus, this.updateStatus),
            },
        };
    }
}
//# sourceMappingURL=RequestNodeNeighborUpdateMessages.js.map