import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes, type BytesView } from "@zwave-js/shared";
export interface ExtNVMWriteLongBufferRequestOptions {
    offset: number;
    buffer: BytesView;
}
export declare class ExtNVMWriteLongBufferRequest extends Message {
    constructor(options: ExtNVMWriteLongBufferRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): ExtNVMWriteLongBufferRequest;
    offset: number;
    buffer: BytesView;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface ExtNVMWriteLongBufferResponseOptions {
    success: boolean;
}
export declare class ExtNVMWriteLongBufferResponse extends Message {
    constructor(options: ExtNVMWriteLongBufferResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): ExtNVMWriteLongBufferResponse;
    readonly success: boolean;
    isOK(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=ExtNVMWriteLongBufferMessages.d.ts.map