"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var message_handler_exports = {};
__export(message_handler_exports, {
  EndpointMessageHandler: () => EndpointMessageHandler
});
module.exports = __toCommonJS(message_handler_exports);
var import_error = require("../error.js");
var import_state = require("../state.js");
var import_command = require("./command.js");
var import_common = require("../common.js");
const isBufferObject = /* @__PURE__ */ __name((obj) => {
  return obj instanceof Object && Object.keys(obj).length === 2 && "type" in obj && obj.type === "Buffer" && "data" in obj && Array.isArray(obj.data);
}, "isBufferObject");
const deserializeBufferInArray = /* @__PURE__ */ __name((array) => {
  for (var idx = 0; idx < array.length; idx++) {
    const value = array[idx];
    if (isBufferObject(value)) {
      array[idx] = Buffer.from(value.data);
    }
  }
  return array;
}, "deserializeBufferInArray");
class EndpointMessageHandler {
  static {
    __name(this, "EndpointMessageHandler");
  }
  driver;
  client;
  constructor(driver, client) {
    this.driver = driver;
    this.client = client;
  }
  async handle(message) {
    const { nodeId, command } = message;
    let endpoint;
    const node = this.driver.controller.nodes.get(nodeId);
    if (!node) {
      throw new import_error.NodeNotFoundError(nodeId);
    }
    if (message.endpoint) {
      endpoint = node.getEndpoint(message.endpoint);
      if (!endpoint) {
        throw new import_error.EndpointNotFoundError(nodeId, message.endpoint);
      }
    } else {
      endpoint = node;
    }
    switch (message.command) {
      case import_command.EndpointCommand.invokeCCAPI: {
        const response = await endpoint.invokeCCAPI(message.commandClass, message.methodName, ...deserializeBufferInArray(message.args));
        return { response };
      }
      case import_command.EndpointCommand.supportsCCAPI: {
        const supported = endpoint.supportsCCAPI(message.commandClass);
        return { supported };
      }
      case import_command.EndpointCommand.supportsCC: {
        const supported = endpoint.supportsCC(message.commandClass);
        return { supported };
      }
      case import_command.EndpointCommand.controlsCC: {
        const controlled = endpoint.controlsCC(message.commandClass);
        return { controlled };
      }
      case import_command.EndpointCommand.isCCSecure: {
        const secure = endpoint.isCCSecure(message.commandClass);
        return { secure };
      }
      case import_command.EndpointCommand.getCCVersion: {
        const version = endpoint.getCCVersion(message.commandClass);
        return { version };
      }
      case import_command.EndpointCommand.getNodeUnsafe:
      case import_command.EndpointCommand.tryGetNode: {
        const node2 = endpoint.tryGetNode();
        return {
          node: node2 === void 0 ? node2 : (0, import_state.dumpNode)(node2, this.client.schemaVersion)
        };
      }
      case import_command.EndpointCommand.setRawConfigParameterValue: {
        return (0, import_common.setRawConfigParameterValue)(message, endpoint);
      }
      case import_command.EndpointCommand.getRawConfigParameterValue: {
        return (0, import_common.getRawConfigParameterValue)(message, endpoint);
      }
      default: {
        throw new import_error.UnknownCommandError(command);
      }
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  EndpointMessageHandler
});
//# sourceMappingURL=message_handler.js.map
